/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CastColumnTypeOperation;
import software.amazon.awssdk.services.quicksight.model.CreateColumnsOperation;
import software.amazon.awssdk.services.quicksight.model.FilterOperation;
import software.amazon.awssdk.services.quicksight.model.ProjectOperation;
import software.amazon.awssdk.services.quicksight.model.RenameColumnOperation;
import software.amazon.awssdk.services.quicksight.model.TagColumnOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformOperation> {
    private static final SdkField<ProjectOperation> PROJECT_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProjectOperation").getter(TransformOperation.getter(TransformOperation::projectOperation)).setter(TransformOperation.setter(Builder::projectOperation)).constructor(ProjectOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectOperation").build()}).build();
    private static final SdkField<FilterOperation> FILTER_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterOperation").getter(TransformOperation.getter(TransformOperation::filterOperation)).setter(TransformOperation.setter(Builder::filterOperation)).constructor(FilterOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOperation").build()}).build();
    private static final SdkField<CreateColumnsOperation> CREATE_COLUMNS_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateColumnsOperation").getter(TransformOperation.getter(TransformOperation::createColumnsOperation)).setter(TransformOperation.setter(Builder::createColumnsOperation)).constructor(CreateColumnsOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateColumnsOperation").build()}).build();
    private static final SdkField<RenameColumnOperation> RENAME_COLUMN_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RenameColumnOperation").getter(TransformOperation.getter(TransformOperation::renameColumnOperation)).setter(TransformOperation.setter(Builder::renameColumnOperation)).constructor(RenameColumnOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameColumnOperation").build()}).build();
    private static final SdkField<CastColumnTypeOperation> CAST_COLUMN_TYPE_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CastColumnTypeOperation").getter(TransformOperation.getter(TransformOperation::castColumnTypeOperation)).setter(TransformOperation.setter(Builder::castColumnTypeOperation)).constructor(CastColumnTypeOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CastColumnTypeOperation").build()}).build();
    private static final SdkField<TagColumnOperation> TAG_COLUMN_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TagColumnOperation").getter(TransformOperation.getter(TransformOperation::tagColumnOperation)).setter(TransformOperation.setter(Builder::tagColumnOperation)).constructor(TagColumnOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagColumnOperation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_OPERATION_FIELD, FILTER_OPERATION_FIELD, CREATE_COLUMNS_OPERATION_FIELD, RENAME_COLUMN_OPERATION_FIELD, CAST_COLUMN_TYPE_OPERATION_FIELD, TAG_COLUMN_OPERATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ProjectOperation projectOperation;
    private final FilterOperation filterOperation;
    private final CreateColumnsOperation createColumnsOperation;
    private final RenameColumnOperation renameColumnOperation;
    private final CastColumnTypeOperation castColumnTypeOperation;
    private final TagColumnOperation tagColumnOperation;

    private TransformOperation(BuilderImpl builder) {
        this.projectOperation = builder.projectOperation;
        this.filterOperation = builder.filterOperation;
        this.createColumnsOperation = builder.createColumnsOperation;
        this.renameColumnOperation = builder.renameColumnOperation;
        this.castColumnTypeOperation = builder.castColumnTypeOperation;
        this.tagColumnOperation = builder.tagColumnOperation;
    }

    public ProjectOperation projectOperation() {
        return this.projectOperation;
    }

    public FilterOperation filterOperation() {
        return this.filterOperation;
    }

    public CreateColumnsOperation createColumnsOperation() {
        return this.createColumnsOperation;
    }

    public RenameColumnOperation renameColumnOperation() {
        return this.renameColumnOperation;
    }

    public CastColumnTypeOperation castColumnTypeOperation() {
        return this.castColumnTypeOperation;
    }

    public TagColumnOperation tagColumnOperation() {
        return this.tagColumnOperation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.createColumnsOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.renameColumnOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.castColumnTypeOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagColumnOperation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformOperation)) {
            return false;
        }
        TransformOperation other = (TransformOperation)obj;
        return Objects.equals(this.projectOperation(), other.projectOperation()) && Objects.equals(this.filterOperation(), other.filterOperation()) && Objects.equals(this.createColumnsOperation(), other.createColumnsOperation()) && Objects.equals(this.renameColumnOperation(), other.renameColumnOperation()) && Objects.equals(this.castColumnTypeOperation(), other.castColumnTypeOperation()) && Objects.equals(this.tagColumnOperation(), other.tagColumnOperation());
    }

    public String toString() {
        return ToString.builder((String)"TransformOperation").add("ProjectOperation", (Object)this.projectOperation()).add("FilterOperation", (Object)this.filterOperation()).add("CreateColumnsOperation", (Object)this.createColumnsOperation()).add("RenameColumnOperation", (Object)this.renameColumnOperation()).add("CastColumnTypeOperation", (Object)this.castColumnTypeOperation()).add("TagColumnOperation", (Object)this.tagColumnOperation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectOperation": {
                return Optional.ofNullable(clazz.cast(this.projectOperation()));
            }
            case "FilterOperation": {
                return Optional.ofNullable(clazz.cast(this.filterOperation()));
            }
            case "CreateColumnsOperation": {
                return Optional.ofNullable(clazz.cast(this.createColumnsOperation()));
            }
            case "RenameColumnOperation": {
                return Optional.ofNullable(clazz.cast(this.renameColumnOperation()));
            }
            case "CastColumnTypeOperation": {
                return Optional.ofNullable(clazz.cast(this.castColumnTypeOperation()));
            }
            case "TagColumnOperation": {
                return Optional.ofNullable(clazz.cast(this.tagColumnOperation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformOperation, T> g) {
        return obj -> g.apply((TransformOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ProjectOperation projectOperation;
        private FilterOperation filterOperation;
        private CreateColumnsOperation createColumnsOperation;
        private RenameColumnOperation renameColumnOperation;
        private CastColumnTypeOperation castColumnTypeOperation;
        private TagColumnOperation tagColumnOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformOperation model) {
            this.projectOperation(model.projectOperation);
            this.filterOperation(model.filterOperation);
            this.createColumnsOperation(model.createColumnsOperation);
            this.renameColumnOperation(model.renameColumnOperation);
            this.castColumnTypeOperation(model.castColumnTypeOperation);
            this.tagColumnOperation(model.tagColumnOperation);
        }

        public final ProjectOperation.Builder getProjectOperation() {
            return this.projectOperation != null ? this.projectOperation.toBuilder() : null;
        }

        @Override
        public final Builder projectOperation(ProjectOperation projectOperation) {
            this.projectOperation = projectOperation;
            return this;
        }

        public final void setProjectOperation(ProjectOperation.BuilderImpl projectOperation) {
            this.projectOperation = projectOperation != null ? projectOperation.build() : null;
        }

        public final FilterOperation.Builder getFilterOperation() {
            return this.filterOperation != null ? this.filterOperation.toBuilder() : null;
        }

        @Override
        public final Builder filterOperation(FilterOperation filterOperation) {
            this.filterOperation = filterOperation;
            return this;
        }

        public final void setFilterOperation(FilterOperation.BuilderImpl filterOperation) {
            this.filterOperation = filterOperation != null ? filterOperation.build() : null;
        }

        public final CreateColumnsOperation.Builder getCreateColumnsOperation() {
            return this.createColumnsOperation != null ? this.createColumnsOperation.toBuilder() : null;
        }

        @Override
        public final Builder createColumnsOperation(CreateColumnsOperation createColumnsOperation) {
            this.createColumnsOperation = createColumnsOperation;
            return this;
        }

        public final void setCreateColumnsOperation(CreateColumnsOperation.BuilderImpl createColumnsOperation) {
            this.createColumnsOperation = createColumnsOperation != null ? createColumnsOperation.build() : null;
        }

        public final RenameColumnOperation.Builder getRenameColumnOperation() {
            return this.renameColumnOperation != null ? this.renameColumnOperation.toBuilder() : null;
        }

        @Override
        public final Builder renameColumnOperation(RenameColumnOperation renameColumnOperation) {
            this.renameColumnOperation = renameColumnOperation;
            return this;
        }

        public final void setRenameColumnOperation(RenameColumnOperation.BuilderImpl renameColumnOperation) {
            this.renameColumnOperation = renameColumnOperation != null ? renameColumnOperation.build() : null;
        }

        public final CastColumnTypeOperation.Builder getCastColumnTypeOperation() {
            return this.castColumnTypeOperation != null ? this.castColumnTypeOperation.toBuilder() : null;
        }

        @Override
        public final Builder castColumnTypeOperation(CastColumnTypeOperation castColumnTypeOperation) {
            this.castColumnTypeOperation = castColumnTypeOperation;
            return this;
        }

        public final void setCastColumnTypeOperation(CastColumnTypeOperation.BuilderImpl castColumnTypeOperation) {
            this.castColumnTypeOperation = castColumnTypeOperation != null ? castColumnTypeOperation.build() : null;
        }

        public final TagColumnOperation.Builder getTagColumnOperation() {
            return this.tagColumnOperation != null ? this.tagColumnOperation.toBuilder() : null;
        }

        @Override
        public final Builder tagColumnOperation(TagColumnOperation tagColumnOperation) {
            this.tagColumnOperation = tagColumnOperation;
            return this;
        }

        public final void setTagColumnOperation(TagColumnOperation.BuilderImpl tagColumnOperation) {
            this.tagColumnOperation = tagColumnOperation != null ? tagColumnOperation.build() : null;
        }

        public TransformOperation build() {
            return new TransformOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformOperation> {
        public Builder projectOperation(ProjectOperation var1);

        default public Builder projectOperation(Consumer<ProjectOperation.Builder> projectOperation) {
            return this.projectOperation((ProjectOperation)((ProjectOperation.Builder)ProjectOperation.builder().applyMutation(projectOperation)).build());
        }

        public Builder filterOperation(FilterOperation var1);

        default public Builder filterOperation(Consumer<FilterOperation.Builder> filterOperation) {
            return this.filterOperation((FilterOperation)((FilterOperation.Builder)FilterOperation.builder().applyMutation(filterOperation)).build());
        }

        public Builder createColumnsOperation(CreateColumnsOperation var1);

        default public Builder createColumnsOperation(Consumer<CreateColumnsOperation.Builder> createColumnsOperation) {
            return this.createColumnsOperation((CreateColumnsOperation)((CreateColumnsOperation.Builder)CreateColumnsOperation.builder().applyMutation(createColumnsOperation)).build());
        }

        public Builder renameColumnOperation(RenameColumnOperation var1);

        default public Builder renameColumnOperation(Consumer<RenameColumnOperation.Builder> renameColumnOperation) {
            return this.renameColumnOperation((RenameColumnOperation)((RenameColumnOperation.Builder)RenameColumnOperation.builder().applyMutation(renameColumnOperation)).build());
        }

        public Builder castColumnTypeOperation(CastColumnTypeOperation var1);

        default public Builder castColumnTypeOperation(Consumer<CastColumnTypeOperation.Builder> castColumnTypeOperation) {
            return this.castColumnTypeOperation((CastColumnTypeOperation)((CastColumnTypeOperation.Builder)CastColumnTypeOperation.builder().applyMutation(castColumnTypeOperation)).build());
        }

        public Builder tagColumnOperation(TagColumnOperation var1);

        default public Builder tagColumnOperation(Consumer<TagColumnOperation.Builder> tagColumnOperation) {
            return this.tagColumnOperation((TagColumnOperation)((TagColumnOperation.Builder)TagColumnOperation.builder().applyMutation(tagColumnOperation)).build());
        }
    }
}

