/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AdditionalDashboardIdListCopier;
import software.amazon.awssdk.services.quicksight.model.EmbeddingIdentityType;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDashboardEmbedUrlRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, GetDashboardEmbedUrlRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(GetDashboardEmbedUrlRequest.getter(GetDashboardEmbedUrlRequest::awsAccountId)).setter(GetDashboardEmbedUrlRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(GetDashboardEmbedUrlRequest.getter(GetDashboardEmbedUrlRequest::dashboardId)).setter(GetDashboardEmbedUrlRequest.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()}).build();
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityType").getter(GetDashboardEmbedUrlRequest.getter(GetDashboardEmbedUrlRequest::identityTypeAsString)).setter(GetDashboardEmbedUrlRequest.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("creds-type").build()}).build();
    private static final SdkField<Long> SESSION_LIFETIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SessionLifetimeInMinutes").getter(GetDashboardEmbedUrlRequest.getter(GetDashboardEmbedUrlRequest::sessionLifetimeInMinutes)).setter(GetDashboardEmbedUrlRequest.setter(Builder::sessionLifetimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("session-lifetime").build()}).build();
    private static final SdkField<Boolean> UNDO_REDO_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UndoRedoDisabled").getter(GetDashboardEmbedUrlRequest.getter(GetDashboardEmbedUrlRequest::undoRedoDisabled)).setter(GetDashboardEmbedUrlRequest.setter(Builder::undoRedoDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("undo-redo-disabled").build()}).build();
    private static final SdkField<Boolean> RESET_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ResetDisabled").getter(GetDashboardEmbedUrlRequest.getter(GetDashboardEmbedUrlRequest::resetDisabled)).setter(GetDashboardEmbedUrlRequest.setter(Builder::resetDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reset-disabled").build()}).build();
    private static final SdkField<Boolean> STATE_PERSISTENCE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StatePersistenceEnabled").getter(GetDashboardEmbedUrlRequest.getter(GetDashboardEmbedUrlRequest::statePersistenceEnabled)).setter(GetDashboardEmbedUrlRequest.setter(Builder::statePersistenceEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state-persistence-enabled").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserArn").getter(GetDashboardEmbedUrlRequest.getter(GetDashboardEmbedUrlRequest::userArn)).setter(GetDashboardEmbedUrlRequest.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("user-arn").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(GetDashboardEmbedUrlRequest.getter(GetDashboardEmbedUrlRequest::namespace)).setter(GetDashboardEmbedUrlRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_DASHBOARD_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalDashboardIds").getter(GetDashboardEmbedUrlRequest.getter(GetDashboardEmbedUrlRequest::additionalDashboardIds)).setter(GetDashboardEmbedUrlRequest.setter(Builder::additionalDashboardIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("additional-dashboard-ids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DASHBOARD_ID_FIELD, IDENTITY_TYPE_FIELD, SESSION_LIFETIME_IN_MINUTES_FIELD, UNDO_REDO_DISABLED_FIELD, RESET_DISABLED_FIELD, STATE_PERSISTENCE_ENABLED_FIELD, USER_ARN_FIELD, NAMESPACE_FIELD, ADDITIONAL_DASHBOARD_IDS_FIELD));
    private final String awsAccountId;
    private final String dashboardId;
    private final String identityType;
    private final Long sessionLifetimeInMinutes;
    private final Boolean undoRedoDisabled;
    private final Boolean resetDisabled;
    private final Boolean statePersistenceEnabled;
    private final String userArn;
    private final String namespace;
    private final List<String> additionalDashboardIds;

    private GetDashboardEmbedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.identityType = builder.identityType;
        this.sessionLifetimeInMinutes = builder.sessionLifetimeInMinutes;
        this.undoRedoDisabled = builder.undoRedoDisabled;
        this.resetDisabled = builder.resetDisabled;
        this.statePersistenceEnabled = builder.statePersistenceEnabled;
        this.userArn = builder.userArn;
        this.namespace = builder.namespace;
        this.additionalDashboardIds = builder.additionalDashboardIds;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String dashboardId() {
        return this.dashboardId;
    }

    public EmbeddingIdentityType identityType() {
        return EmbeddingIdentityType.fromValue(this.identityType);
    }

    public String identityTypeAsString() {
        return this.identityType;
    }

    public Long sessionLifetimeInMinutes() {
        return this.sessionLifetimeInMinutes;
    }

    public Boolean undoRedoDisabled() {
        return this.undoRedoDisabled;
    }

    public Boolean resetDisabled() {
        return this.resetDisabled;
    }

    public Boolean statePersistenceEnabled() {
        return this.statePersistenceEnabled;
    }

    public String userArn() {
        return this.userArn;
    }

    public String namespace() {
        return this.namespace;
    }

    public boolean hasAdditionalDashboardIds() {
        return this.additionalDashboardIds != null && !(this.additionalDashboardIds instanceof SdkAutoConstructList);
    }

    public List<String> additionalDashboardIds() {
        return this.additionalDashboardIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionLifetimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.undoRedoDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.statePersistenceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalDashboardIds() ? this.additionalDashboardIds() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashboardEmbedUrlRequest)) {
            return false;
        }
        GetDashboardEmbedUrlRequest other = (GetDashboardEmbedUrlRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dashboardId(), other.dashboardId()) && Objects.equals(this.identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(this.sessionLifetimeInMinutes(), other.sessionLifetimeInMinutes()) && Objects.equals(this.undoRedoDisabled(), other.undoRedoDisabled()) && Objects.equals(this.resetDisabled(), other.resetDisabled()) && Objects.equals(this.statePersistenceEnabled(), other.statePersistenceEnabled()) && Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.namespace(), other.namespace()) && this.hasAdditionalDashboardIds() == other.hasAdditionalDashboardIds() && Objects.equals(this.additionalDashboardIds(), other.additionalDashboardIds());
    }

    public String toString() {
        return ToString.builder((String)"GetDashboardEmbedUrlRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DashboardId", (Object)this.dashboardId()).add("IdentityType", (Object)this.identityTypeAsString()).add("SessionLifetimeInMinutes", (Object)this.sessionLifetimeInMinutes()).add("UndoRedoDisabled", (Object)this.undoRedoDisabled()).add("ResetDisabled", (Object)this.resetDisabled()).add("StatePersistenceEnabled", (Object)this.statePersistenceEnabled()).add("UserArn", (Object)this.userArn()).add("Namespace", (Object)this.namespace()).add("AdditionalDashboardIds", this.hasAdditionalDashboardIds() ? this.additionalDashboardIds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "IdentityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
            case "SessionLifetimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.sessionLifetimeInMinutes()));
            }
            case "UndoRedoDisabled": {
                return Optional.ofNullable(clazz.cast(this.undoRedoDisabled()));
            }
            case "ResetDisabled": {
                return Optional.ofNullable(clazz.cast(this.resetDisabled()));
            }
            case "StatePersistenceEnabled": {
                return Optional.ofNullable(clazz.cast(this.statePersistenceEnabled()));
            }
            case "UserArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "AdditionalDashboardIds": {
                return Optional.ofNullable(clazz.cast(this.additionalDashboardIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDashboardEmbedUrlRequest, T> g) {
        return obj -> g.apply((GetDashboardEmbedUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dashboardId;
        private String identityType;
        private Long sessionLifetimeInMinutes;
        private Boolean undoRedoDisabled;
        private Boolean resetDisabled;
        private Boolean statePersistenceEnabled;
        private String userArn;
        private String namespace;
        private List<String> additionalDashboardIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashboardEmbedUrlRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dashboardId(model.dashboardId);
            this.identityType(model.identityType);
            this.sessionLifetimeInMinutes(model.sessionLifetimeInMinutes);
            this.undoRedoDisabled(model.undoRedoDisabled);
            this.resetDisabled(model.resetDisabled);
            this.statePersistenceEnabled(model.statePersistenceEnabled);
            this.userArn(model.userArn);
            this.namespace(model.namespace);
            this.additionalDashboardIds(model.additionalDashboardIds);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(EmbeddingIdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final Long getSessionLifetimeInMinutes() {
            return this.sessionLifetimeInMinutes;
        }

        @Override
        public final Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
            return this;
        }

        public final void setSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
        }

        public final Boolean getUndoRedoDisabled() {
            return this.undoRedoDisabled;
        }

        @Override
        public final Builder undoRedoDisabled(Boolean undoRedoDisabled) {
            this.undoRedoDisabled = undoRedoDisabled;
            return this;
        }

        public final void setUndoRedoDisabled(Boolean undoRedoDisabled) {
            this.undoRedoDisabled = undoRedoDisabled;
        }

        public final Boolean getResetDisabled() {
            return this.resetDisabled;
        }

        @Override
        public final Builder resetDisabled(Boolean resetDisabled) {
            this.resetDisabled = resetDisabled;
            return this;
        }

        public final void setResetDisabled(Boolean resetDisabled) {
            this.resetDisabled = resetDisabled;
        }

        public final Boolean getStatePersistenceEnabled() {
            return this.statePersistenceEnabled;
        }

        @Override
        public final Builder statePersistenceEnabled(Boolean statePersistenceEnabled) {
            this.statePersistenceEnabled = statePersistenceEnabled;
            return this;
        }

        public final void setStatePersistenceEnabled(Boolean statePersistenceEnabled) {
            this.statePersistenceEnabled = statePersistenceEnabled;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Collection<String> getAdditionalDashboardIds() {
            if (this.additionalDashboardIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalDashboardIds;
        }

        @Override
        public final Builder additionalDashboardIds(Collection<String> additionalDashboardIds) {
            this.additionalDashboardIds = AdditionalDashboardIdListCopier.copy(additionalDashboardIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalDashboardIds(String ... additionalDashboardIds) {
            this.additionalDashboardIds(Arrays.asList(additionalDashboardIds));
            return this;
        }

        public final void setAdditionalDashboardIds(Collection<String> additionalDashboardIds) {
            this.additionalDashboardIds = AdditionalDashboardIdListCopier.copy(additionalDashboardIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDashboardEmbedUrlRequest build() {
            return new GetDashboardEmbedUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDashboardEmbedUrlRequest> {
        public Builder awsAccountId(String var1);

        public Builder dashboardId(String var1);

        public Builder identityType(String var1);

        public Builder identityType(EmbeddingIdentityType var1);

        public Builder sessionLifetimeInMinutes(Long var1);

        public Builder undoRedoDisabled(Boolean var1);

        public Builder resetDisabled(Boolean var1);

        public Builder statePersistenceEnabled(Boolean var1);

        public Builder userArn(String var1);

        public Builder namespace(String var1);

        public Builder additionalDashboardIds(Collection<String> var1);

        public Builder additionalDashboardIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

