/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.TemplateAlias;
import software.amazon.awssdk.services.quicksight.model.TemplateAliasListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTemplateAliasesResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListTemplateAliasesResponse> {
    private static final SdkField<List<TemplateAlias>> TEMPLATE_ALIAS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TemplateAliasList").getter(ListTemplateAliasesResponse.getter(ListTemplateAliasesResponse::templateAliasList)).setter(ListTemplateAliasesResponse.setter(Builder::templateAliasList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateAliasList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListTemplateAliasesResponse.getter(ListTemplateAliasesResponse::status)).setter(ListTemplateAliasesResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListTemplateAliasesResponse.getter(ListTemplateAliasesResponse::requestId)).setter(ListTemplateAliasesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTemplateAliasesResponse.getter(ListTemplateAliasesResponse::nextToken)).setter(ListTemplateAliasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ALIAS_LIST_FIELD, STATUS_FIELD, REQUEST_ID_FIELD, NEXT_TOKEN_FIELD));
    private final List<TemplateAlias> templateAliasList;
    private final Integer status;
    private final String requestId;
    private final String nextToken;

    private ListTemplateAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.templateAliasList = builder.templateAliasList;
        this.status = builder.status;
        this.requestId = builder.requestId;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTemplateAliasList() {
        return this.templateAliasList != null && !(this.templateAliasList instanceof SdkAutoConstructList);
    }

    public List<TemplateAlias> templateAliasList() {
        return this.templateAliasList;
    }

    public Integer status() {
        return this.status;
    }

    public String requestId() {
        return this.requestId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateAliasList() ? this.templateAliasList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateAliasesResponse)) {
            return false;
        }
        ListTemplateAliasesResponse other = (ListTemplateAliasesResponse)((Object)obj);
        return this.hasTemplateAliasList() == other.hasTemplateAliasList() && Objects.equals(this.templateAliasList(), other.templateAliasList()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTemplateAliasesResponse").add("TemplateAliasList", this.hasTemplateAliasList() ? this.templateAliasList() : null).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateAliasList": {
                return Optional.ofNullable(clazz.cast(this.templateAliasList()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateAliasesResponse, T> g) {
        return obj -> g.apply((ListTemplateAliasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<TemplateAlias> templateAliasList = DefaultSdkAutoConstructList.getInstance();
        private Integer status;
        private String requestId;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateAliasesResponse model) {
            super(model);
            this.templateAliasList(model.templateAliasList);
            this.status(model.status);
            this.requestId(model.requestId);
            this.nextToken(model.nextToken);
        }

        public final Collection<TemplateAlias.Builder> getTemplateAliasList() {
            if (this.templateAliasList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.templateAliasList != null ? (Collection)this.templateAliasList.stream().map(TemplateAlias::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder templateAliasList(Collection<TemplateAlias> templateAliasList) {
            this.templateAliasList = TemplateAliasListCopier.copy(templateAliasList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateAliasList(TemplateAlias ... templateAliasList) {
            this.templateAliasList(Arrays.asList(templateAliasList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateAliasList(Consumer<TemplateAlias.Builder> ... templateAliasList) {
            this.templateAliasList(Stream.of(templateAliasList).map(c -> (TemplateAlias)((TemplateAlias.Builder)TemplateAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTemplateAliasList(Collection<TemplateAlias.BuilderImpl> templateAliasList) {
            this.templateAliasList = TemplateAliasListCopier.copyFromBuilder(templateAliasList);
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTemplateAliasesResponse build() {
            return new ListTemplateAliasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTemplateAliasesResponse> {
        public Builder templateAliasList(Collection<TemplateAlias> var1);

        public Builder templateAliasList(TemplateAlias ... var1);

        public Builder templateAliasList(Consumer<TemplateAlias.Builder> ... var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);

        public Builder nextToken(String var1);
    }
}

