/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.User;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterUserResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, RegisterUserResponse> {
    private static final SdkField<User> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("User").getter(RegisterUserResponse.getter(RegisterUserResponse::user)).setter(RegisterUserResponse.setter(Builder::user)).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<String> USER_INVITATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserInvitationUrl").getter(RegisterUserResponse.getter(RegisterUserResponse::userInvitationUrl)).setter(RegisterUserResponse.setter(Builder::userInvitationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInvitationUrl").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(RegisterUserResponse.getter(RegisterUserResponse::requestId)).setter(RegisterUserResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(RegisterUserResponse.getter(RegisterUserResponse::status)).setter(RegisterUserResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, USER_INVITATION_URL_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final User user;
    private final String userInvitationUrl;
    private final String requestId;
    private final Integer status;

    private RegisterUserResponse(BuilderImpl builder) {
        super(builder);
        this.user = builder.user;
        this.userInvitationUrl = builder.userInvitationUrl;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public User user() {
        return this.user;
    }

    public String userInvitationUrl() {
        return this.userInvitationUrl;
    }

    public String requestId() {
        return this.requestId;
    }

    public Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInvitationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterUserResponse)) {
            return false;
        }
        RegisterUserResponse other = (RegisterUserResponse)((Object)obj);
        return Objects.equals(this.user(), other.user()) && Objects.equals(this.userInvitationUrl(), other.userInvitationUrl()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"RegisterUserResponse").add("User", (Object)this.user()).add("UserInvitationUrl", (Object)this.userInvitationUrl()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "UserInvitationUrl": {
                return Optional.ofNullable(clazz.cast(this.userInvitationUrl()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterUserResponse, T> g) {
        return obj -> g.apply((RegisterUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private User user;
        private String userInvitationUrl;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterUserResponse model) {
            super(model);
            this.user(model.user);
            this.userInvitationUrl(model.userInvitationUrl);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final User.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        @Override
        public final Builder user(User user) {
            this.user = user;
            return this;
        }

        public final void setUser(User.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        public final String getUserInvitationUrl() {
            return this.userInvitationUrl;
        }

        @Override
        public final Builder userInvitationUrl(String userInvitationUrl) {
            this.userInvitationUrl = userInvitationUrl;
            return this;
        }

        public final void setUserInvitationUrl(String userInvitationUrl) {
            this.userInvitationUrl = userInvitationUrl;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public RegisterUserResponse build() {
            return new RegisterUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterUserResponse> {
        public Builder user(User var1);

        default public Builder user(Consumer<User.Builder> user) {
            return this.user((User)((User.Builder)User.builder().applyMutation(user)).build());
        }

        public Builder userInvitationUrl(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

