/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccountSettingsRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateAccountSettingsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateAccountSettingsRequest.getter(UpdateAccountSettingsRequest::awsAccountId)).setter(UpdateAccountSettingsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DEFAULT_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultNamespace").getter(UpdateAccountSettingsRequest.getter(UpdateAccountSettingsRequest::defaultNamespace)).setter(UpdateAccountSettingsRequest.setter(Builder::defaultNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultNamespace").build()}).build();
    private static final SdkField<String> NOTIFICATION_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationEmail").getter(UpdateAccountSettingsRequest.getter(UpdateAccountSettingsRequest::notificationEmail)).setter(UpdateAccountSettingsRequest.setter(Builder::notificationEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEmail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DEFAULT_NAMESPACE_FIELD, NOTIFICATION_EMAIL_FIELD));
    private final String awsAccountId;
    private final String defaultNamespace;
    private final String notificationEmail;

    private UpdateAccountSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.defaultNamespace = builder.defaultNamespace;
        this.notificationEmail = builder.notificationEmail;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String defaultNamespace() {
        return this.defaultNamespace;
    }

    public String notificationEmail() {
        return this.notificationEmail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEmail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsRequest)) {
            return false;
        }
        UpdateAccountSettingsRequest other = (UpdateAccountSettingsRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.defaultNamespace(), other.defaultNamespace()) && Objects.equals(this.notificationEmail(), other.notificationEmail());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAccountSettingsRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DefaultNamespace", (Object)this.defaultNamespace()).add("NotificationEmail", (Object)this.notificationEmail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DefaultNamespace": {
                return Optional.ofNullable(clazz.cast(this.defaultNamespace()));
            }
            case "NotificationEmail": {
                return Optional.ofNullable(clazz.cast(this.notificationEmail()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsRequest, T> g) {
        return obj -> g.apply((UpdateAccountSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String defaultNamespace;
        private String notificationEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.defaultNamespace(model.defaultNamespace);
            this.notificationEmail(model.notificationEmail);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDefaultNamespace() {
            return this.defaultNamespace;
        }

        @Override
        public final Builder defaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
            return this;
        }

        public final void setDefaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
        }

        public final String getNotificationEmail() {
            return this.notificationEmail;
        }

        @Override
        public final Builder notificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
            return this;
        }

        public final void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountSettingsRequest build() {
            return new UpdateAccountSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccountSettingsRequest> {
        public Builder awsAccountId(String var1);

        public Builder defaultNamespace(String var1);

        public Builder notificationEmail(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

