/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.services.quicksight.model.ThemeConfiguration;
import software.amazon.awssdk.services.quicksight.model.ThemeError;
import software.amazon.awssdk.services.quicksight.model.ThemeErrorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThemeVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThemeVersion> {
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(ThemeVersion.getter(ThemeVersion::versionNumber)).setter(ThemeVersion.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ThemeVersion.getter(ThemeVersion::arn)).setter(ThemeVersion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ThemeVersion.getter(ThemeVersion::description)).setter(ThemeVersion.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> BASE_THEME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseThemeId").getter(ThemeVersion.getter(ThemeVersion::baseThemeId)).setter(ThemeVersion.setter(Builder::baseThemeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseThemeId").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ThemeVersion.getter(ThemeVersion::createdTime)).setter(ThemeVersion.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<ThemeConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(ThemeVersion.getter(ThemeVersion::configuration)).setter(ThemeVersion.setter(Builder::configuration)).constructor(ThemeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<List<ThemeError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(ThemeVersion.getter(ThemeVersion::errors)).setter(ThemeVersion.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThemeError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ThemeVersion.getter(ThemeVersion::statusAsString)).setter(ThemeVersion.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_NUMBER_FIELD, ARN_FIELD, DESCRIPTION_FIELD, BASE_THEME_ID_FIELD, CREATED_TIME_FIELD, CONFIGURATION_FIELD, ERRORS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long versionNumber;
    private final String arn;
    private final String description;
    private final String baseThemeId;
    private final Instant createdTime;
    private final ThemeConfiguration configuration;
    private final List<ThemeError> errors;
    private final String status;

    private ThemeVersion(BuilderImpl builder) {
        this.versionNumber = builder.versionNumber;
        this.arn = builder.arn;
        this.description = builder.description;
        this.baseThemeId = builder.baseThemeId;
        this.createdTime = builder.createdTime;
        this.configuration = builder.configuration;
        this.errors = builder.errors;
        this.status = builder.status;
    }

    public Long versionNumber() {
        return this.versionNumber;
    }

    public String arn() {
        return this.arn;
    }

    public String description() {
        return this.description;
    }

    public String baseThemeId() {
        return this.baseThemeId;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public ThemeConfiguration configuration() {
        return this.configuration;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<ThemeError> errors() {
        return this.errors;
    }

    public ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseThemeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeVersion)) {
            return false;
        }
        ThemeVersion other = (ThemeVersion)obj;
        return Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.baseThemeId(), other.baseThemeId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ThemeVersion").add("VersionNumber", (Object)this.versionNumber()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("BaseThemeId", (Object)this.baseThemeId()).add("CreatedTime", (Object)this.createdTime()).add("Configuration", (Object)this.configuration()).add("Errors", this.errors()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "BaseThemeId": {
                return Optional.ofNullable(clazz.cast(this.baseThemeId()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThemeVersion, T> g) {
        return obj -> g.apply((ThemeVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long versionNumber;
        private String arn;
        private String description;
        private String baseThemeId;
        private Instant createdTime;
        private ThemeConfiguration configuration;
        private List<ThemeError> errors = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ThemeVersion model) {
            this.versionNumber(model.versionNumber);
            this.arn(model.arn);
            this.description(model.description);
            this.baseThemeId(model.baseThemeId);
            this.createdTime(model.createdTime);
            this.configuration(model.configuration);
            this.errors(model.errors);
            this.status(model.status);
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBaseThemeId() {
            return this.baseThemeId;
        }

        @Override
        public final Builder baseThemeId(String baseThemeId) {
            this.baseThemeId = baseThemeId;
            return this;
        }

        public final void setBaseThemeId(String baseThemeId) {
            this.baseThemeId = baseThemeId;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final ThemeConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ThemeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ThemeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final Collection<ThemeError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(ThemeError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<ThemeError> errors) {
            this.errors = ThemeErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ThemeError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ThemeError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (ThemeError)((ThemeError.Builder)ThemeError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<ThemeError.BuilderImpl> errors) {
            this.errors = ThemeErrorListCopier.copyFromBuilder(errors);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ThemeVersion build() {
            return new ThemeVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThemeVersion> {
        public Builder versionNumber(Long var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder baseThemeId(String var1);

        public Builder createdTime(Instant var1);

        public Builder configuration(ThemeConfiguration var1);

        default public Builder configuration(Consumer<ThemeConfiguration.Builder> configuration) {
            return this.configuration((ThemeConfiguration)((ThemeConfiguration.Builder)ThemeConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder errors(Collection<ThemeError> var1);

        public Builder errors(ThemeError ... var1);

        public Builder errors(Consumer<ThemeError.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);
    }
}

