/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DashboardSummary;
import software.amazon.awssdk.services.quicksight.model.DashboardSummaryListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchDashboardsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, SearchDashboardsResponse> {
    private static final SdkField<List<DashboardSummary>> DASHBOARD_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashboardSummaryList").getter(SearchDashboardsResponse.getter(SearchDashboardsResponse::dashboardSummaryList)).setter(SearchDashboardsResponse.setter(Builder::dashboardSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashboardSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchDashboardsResponse.getter(SearchDashboardsResponse::nextToken)).setter(SearchDashboardsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(SearchDashboardsResponse.getter(SearchDashboardsResponse::status)).setter(SearchDashboardsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(SearchDashboardsResponse.getter(SearchDashboardsResponse::requestId)).setter(SearchDashboardsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final List<DashboardSummary> dashboardSummaryList;
    private final String nextToken;
    private final Integer status;
    private final String requestId;

    private SearchDashboardsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardSummaryList = builder.dashboardSummaryList;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public boolean hasDashboardSummaryList() {
        return this.dashboardSummaryList != null && !(this.dashboardSummaryList instanceof SdkAutoConstructList);
    }

    public List<DashboardSummary> dashboardSummaryList() {
        return this.dashboardSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer status() {
        return this.status;
    }

    public String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDashboardsResponse)) {
            return false;
        }
        SearchDashboardsResponse other = (SearchDashboardsResponse)((Object)obj);
        return Objects.equals(this.dashboardSummaryList(), other.dashboardSummaryList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public String toString() {
        return ToString.builder((String)"SearchDashboardsResponse").add("DashboardSummaryList", this.dashboardSummaryList()).add("NextToken", (Object)this.nextToken()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardSummaryList": {
                return Optional.ofNullable(clazz.cast(this.dashboardSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchDashboardsResponse, T> g) {
        return obj -> g.apply((SearchDashboardsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<DashboardSummary> dashboardSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchDashboardsResponse model) {
            super(model);
            this.dashboardSummaryList(model.dashboardSummaryList);
            this.nextToken(model.nextToken);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final Collection<DashboardSummary.Builder> getDashboardSummaryList() {
            return this.dashboardSummaryList != null ? (Collection)this.dashboardSummaryList.stream().map(DashboardSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashboardSummaryList(Collection<DashboardSummary> dashboardSummaryList) {
            this.dashboardSummaryList = DashboardSummaryListCopier.copy(dashboardSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardSummaryList(DashboardSummary ... dashboardSummaryList) {
            this.dashboardSummaryList(Arrays.asList(dashboardSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardSummaryList(Consumer<DashboardSummary.Builder> ... dashboardSummaryList) {
            this.dashboardSummaryList(Stream.of(dashboardSummaryList).map(c -> (DashboardSummary)((DashboardSummary.Builder)DashboardSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDashboardSummaryList(Collection<DashboardSummary.BuilderImpl> dashboardSummaryList) {
            this.dashboardSummaryList = DashboardSummaryListCopier.copyFromBuilder(dashboardSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public SearchDashboardsResponse build() {
            return new SearchDashboardsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchDashboardsResponse> {
        public Builder dashboardSummaryList(Collection<DashboardSummary> var1);

        public Builder dashboardSummaryList(DashboardSummary ... var1);

        public Builder dashboardSummaryList(Consumer<DashboardSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

