/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataSourceType {
    ADOBE_ANALYTICS("ADOBE_ANALYTICS"),
    AMAZON_ELASTICSEARCH("AMAZON_ELASTICSEARCH"),
    ATHENA("ATHENA"),
    AURORA("AURORA"),
    AURORA_POSTGRESQL("AURORA_POSTGRESQL"),
    AWS_IOT_ANALYTICS("AWS_IOT_ANALYTICS"),
    GITHUB("GITHUB"),
    JIRA("JIRA"),
    MARIADB("MARIADB"),
    MYSQL("MYSQL"),
    POSTGRESQL("POSTGRESQL"),
    PRESTO("PRESTO"),
    REDSHIFT("REDSHIFT"),
    S3("S3"),
    SALESFORCE("SALESFORCE"),
    SERVICENOW("SERVICENOW"),
    SNOWFLAKE("SNOWFLAKE"),
    SPARK("SPARK"),
    SQLSERVER("SQLSERVER"),
    TERADATA("TERADATA"),
    TWITTER("TWITTER"),
    TIMESTREAM("TIMESTREAM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataSourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceType> knownValues() {
        return Stream.of(DataSourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

