/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnalysisError;
import software.amazon.awssdk.services.quicksight.model.AnalysisErrorListCopier;
import software.amazon.awssdk.services.quicksight.model.DataSetArnsListCopier;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Analysis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Analysis> {
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Analysis.getter(Analysis::analysisId)).setter(Analysis.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Analysis.getter(Analysis::arn)).setter(Analysis.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Analysis.getter(Analysis::name)).setter(Analysis.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Analysis.getter(Analysis::statusAsString)).setter(Analysis.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<AnalysisError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Analysis.getter(Analysis::errors)).setter(Analysis.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DATA_SET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Analysis.getter(Analysis::dataSetArns)).setter(Analysis.setter(Builder::dataSetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> THEME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Analysis.getter(Analysis::themeArn)).setter(Analysis.setter(Builder::themeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Analysis.getter(Analysis::createdTime)).setter(Analysis.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Analysis.getter(Analysis::lastUpdatedTime)).setter(Analysis.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_ID_FIELD, ARN_FIELD, NAME_FIELD, STATUS_FIELD, ERRORS_FIELD, DATA_SET_ARNS_FIELD, THEME_ARN_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String analysisId;
    private final String arn;
    private final String name;
    private final String status;
    private final List<AnalysisError> errors;
    private final List<String> dataSetArns;
    private final String themeArn;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;

    private Analysis(BuilderImpl builder) {
        this.analysisId = builder.analysisId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.errors = builder.errors;
        this.dataSetArns = builder.dataSetArns;
        this.themeArn = builder.themeArn;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public String analysisId() {
        return this.analysisId;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<AnalysisError> errors() {
        return this.errors;
    }

    public boolean hasDataSetArns() {
        return this.dataSetArns != null && !(this.dataSetArns instanceof SdkAutoConstructList);
    }

    public List<String> dataSetArns() {
        return this.dataSetArns;
    }

    public String themeArn() {
        return this.themeArn;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Analysis)) {
            return false;
        }
        Analysis other = (Analysis)obj;
        return Objects.equals(this.analysisId(), other.analysisId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.dataSetArns(), other.dataSetArns()) && Objects.equals(this.themeArn(), other.themeArn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public String toString() {
        return ToString.builder((String)"Analysis").add("AnalysisId", (Object)this.analysisId()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Errors", this.errors()).add("DataSetArns", this.dataSetArns()).add("ThemeArn", (Object)this.themeArn()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "DataSetArns": {
                return Optional.ofNullable(clazz.cast(this.dataSetArns()));
            }
            case "ThemeArn": {
                return Optional.ofNullable(clazz.cast(this.themeArn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Analysis, T> g) {
        return obj -> g.apply((Analysis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String analysisId;
        private String arn;
        private String name;
        private String status;
        private List<AnalysisError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<String> dataSetArns = DefaultSdkAutoConstructList.getInstance();
        private String themeArn;
        private Instant createdTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Analysis model) {
            this.analysisId(model.analysisId);
            this.arn(model.arn);
            this.name(model.name);
            this.status(model.status);
            this.errors(model.errors);
            this.dataSetArns(model.dataSetArns);
            this.themeArn(model.themeArn);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<AnalysisError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(AnalysisError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<AnalysisError> errors) {
            this.errors = AnalysisErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AnalysisError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AnalysisError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (AnalysisError)((AnalysisError.Builder)AnalysisError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<AnalysisError.BuilderImpl> errors) {
            this.errors = AnalysisErrorListCopier.copyFromBuilder(errors);
        }

        public final Collection<String> getDataSetArns() {
            return this.dataSetArns;
        }

        @Override
        public final Builder dataSetArns(Collection<String> dataSetArns) {
            this.dataSetArns = DataSetArnsListCopier.copy(dataSetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetArns(String ... dataSetArns) {
            this.dataSetArns(Arrays.asList(dataSetArns));
            return this;
        }

        public final void setDataSetArns(Collection<String> dataSetArns) {
            this.dataSetArns = DataSetArnsListCopier.copy(dataSetArns);
        }

        public final String getThemeArn() {
            return this.themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public Analysis build() {
            return new Analysis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Analysis> {
        public Builder analysisId(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder errors(Collection<AnalysisError> var1);

        public Builder errors(AnalysisError ... var1);

        public Builder errors(Consumer<AnalysisError.Builder> ... var1);

        public Builder dataSetArns(Collection<String> var1);

        public Builder dataSetArns(String ... var1);

        public Builder themeArn(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

