/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.IdentityStore;
import software.amazon.awssdk.services.quicksight.model.NamespaceError;
import software.amazon.awssdk.services.quicksight.model.NamespaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NamespaceInfoV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NamespaceInfoV2> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NamespaceInfoV2.getter(NamespaceInfoV2::name)).setter(NamespaceInfoV2.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NamespaceInfoV2.getter(NamespaceInfoV2::arn)).setter(NamespaceInfoV2.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CAPACITY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NamespaceInfoV2.getter(NamespaceInfoV2::capacityRegion)).setter(NamespaceInfoV2.setter(Builder::capacityRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRegion").build()}).build();
    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NamespaceInfoV2.getter(NamespaceInfoV2::creationStatusAsString)).setter(NamespaceInfoV2.setter(Builder::creationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()}).build();
    private static final SdkField<String> IDENTITY_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NamespaceInfoV2.getter(NamespaceInfoV2::identityStoreAsString)).setter(NamespaceInfoV2.setter(Builder::identityStore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStore").build()}).build();
    private static final SdkField<NamespaceError> NAMESPACE_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NamespaceInfoV2.getter(NamespaceInfoV2::namespaceError)).setter(NamespaceInfoV2.setter(Builder::namespaceError)).constructor(NamespaceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceError").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, CAPACITY_REGION_FIELD, CREATION_STATUS_FIELD, IDENTITY_STORE_FIELD, NAMESPACE_ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String capacityRegion;
    private final String creationStatus;
    private final String identityStore;
    private final NamespaceError namespaceError;

    private NamespaceInfoV2(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.capacityRegion = builder.capacityRegion;
        this.creationStatus = builder.creationStatus;
        this.identityStore = builder.identityStore;
        this.namespaceError = builder.namespaceError;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String capacityRegion() {
        return this.capacityRegion;
    }

    public NamespaceStatus creationStatus() {
        return NamespaceStatus.fromValue(this.creationStatus);
    }

    public String creationStatusAsString() {
        return this.creationStatus;
    }

    public IdentityStore identityStore() {
        return IdentityStore.fromValue(this.identityStore);
    }

    public String identityStoreAsString() {
        return this.identityStore;
    }

    public NamespaceError namespaceError() {
        return this.namespaceError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceError());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceInfoV2)) {
            return false;
        }
        NamespaceInfoV2 other = (NamespaceInfoV2)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.capacityRegion(), other.capacityRegion()) && Objects.equals(this.creationStatusAsString(), other.creationStatusAsString()) && Objects.equals(this.identityStoreAsString(), other.identityStoreAsString()) && Objects.equals(this.namespaceError(), other.namespaceError());
    }

    public String toString() {
        return ToString.builder((String)"NamespaceInfoV2").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("CapacityRegion", (Object)this.capacityRegion()).add("CreationStatus", (Object)this.creationStatusAsString()).add("IdentityStore", (Object)this.identityStoreAsString()).add("NamespaceError", (Object)this.namespaceError()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CapacityRegion": {
                return Optional.ofNullable(clazz.cast(this.capacityRegion()));
            }
            case "CreationStatus": {
                return Optional.ofNullable(clazz.cast(this.creationStatusAsString()));
            }
            case "IdentityStore": {
                return Optional.ofNullable(clazz.cast(this.identityStoreAsString()));
            }
            case "NamespaceError": {
                return Optional.ofNullable(clazz.cast(this.namespaceError()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NamespaceInfoV2, T> g) {
        return obj -> g.apply((NamespaceInfoV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String capacityRegion;
        private String creationStatus;
        private String identityStore;
        private NamespaceError namespaceError;

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceInfoV2 model) {
            this.name(model.name);
            this.arn(model.arn);
            this.capacityRegion(model.capacityRegion);
            this.creationStatus(model.creationStatus);
            this.identityStore(model.identityStore);
            this.namespaceError(model.namespaceError);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCapacityRegion() {
            return this.capacityRegion;
        }

        @Override
        public final Builder capacityRegion(String capacityRegion) {
            this.capacityRegion = capacityRegion;
            return this;
        }

        public final void setCapacityRegion(String capacityRegion) {
            this.capacityRegion = capacityRegion;
        }

        public final String getCreationStatus() {
            return this.creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(NamespaceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        public final String getIdentityStore() {
            return this.identityStore;
        }

        @Override
        public final Builder identityStore(String identityStore) {
            this.identityStore = identityStore;
            return this;
        }

        @Override
        public final Builder identityStore(IdentityStore identityStore) {
            this.identityStore(identityStore == null ? null : identityStore.toString());
            return this;
        }

        public final void setIdentityStore(String identityStore) {
            this.identityStore = identityStore;
        }

        public final NamespaceError.Builder getNamespaceError() {
            return this.namespaceError != null ? this.namespaceError.toBuilder() : null;
        }

        @Override
        public final Builder namespaceError(NamespaceError namespaceError) {
            this.namespaceError = namespaceError;
            return this;
        }

        public final void setNamespaceError(NamespaceError.BuilderImpl namespaceError) {
            this.namespaceError = namespaceError != null ? namespaceError.build() : null;
        }

        public NamespaceInfoV2 build() {
            return new NamespaceInfoV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NamespaceInfoV2> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder capacityRegion(String var1);

        public Builder creationStatus(String var1);

        public Builder creationStatus(NamespaceStatus var1);

        public Builder identityStore(String var1);

        public Builder identityStore(IdentityStore var1);

        public Builder namespaceError(NamespaceError var1);

        default public Builder namespaceError(Consumer<NamespaceError.Builder> namespaceError) {
            return this.namespaceError((NamespaceError)((NamespaceError.Builder)NamespaceError.builder().applyMutation(namespaceError)).build());
        }
    }
}

