/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AccountCustomization;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccountCustomizationResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateAccountCustomizationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAccountCustomizationResponse.getter(UpdateAccountCustomizationResponse::arn)).setter(UpdateAccountCustomizationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAccountCustomizationResponse.getter(UpdateAccountCustomizationResponse::awsAccountId)).setter(UpdateAccountCustomizationResponse.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAccountCustomizationResponse.getter(UpdateAccountCustomizationResponse::namespace)).setter(UpdateAccountCustomizationResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<AccountCustomization> ACCOUNT_CUSTOMIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateAccountCustomizationResponse.getter(UpdateAccountCustomizationResponse::accountCustomization)).setter(UpdateAccountCustomizationResponse.setter(Builder::accountCustomization)).constructor(AccountCustomization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountCustomization").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAccountCustomizationResponse.getter(UpdateAccountCustomizationResponse::requestId)).setter(UpdateAccountCustomizationResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateAccountCustomizationResponse.getter(UpdateAccountCustomizationResponse::status)).setter(UpdateAccountCustomizationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, ACCOUNT_CUSTOMIZATION_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final String arn;
    private final String awsAccountId;
    private final String namespace;
    private final AccountCustomization accountCustomization;
    private final String requestId;
    private final Integer status;

    private UpdateAccountCustomizationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.accountCustomization = builder.accountCustomization;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public String arn() {
        return this.arn;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String namespace() {
        return this.namespace;
    }

    public AccountCustomization accountCustomization() {
        return this.accountCustomization;
    }

    public String requestId() {
        return this.requestId;
    }

    public Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountCustomization());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountCustomizationResponse)) {
            return false;
        }
        UpdateAccountCustomizationResponse other = (UpdateAccountCustomizationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.accountCustomization(), other.accountCustomization()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAccountCustomizationResponse").add("Arn", (Object)this.arn()).add("AwsAccountId", (Object)this.awsAccountId()).add("Namespace", (Object)this.namespace()).add("AccountCustomization", (Object)this.accountCustomization()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "AccountCustomization": {
                return Optional.ofNullable(clazz.cast(this.accountCustomization()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountCustomizationResponse, T> g) {
        return obj -> g.apply((UpdateAccountCustomizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String awsAccountId;
        private String namespace;
        private AccountCustomization accountCustomization;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountCustomizationResponse model) {
            super(model);
            this.arn(model.arn);
            this.awsAccountId(model.awsAccountId);
            this.namespace(model.namespace);
            this.accountCustomization(model.accountCustomization);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final AccountCustomization.Builder getAccountCustomization() {
            return this.accountCustomization != null ? this.accountCustomization.toBuilder() : null;
        }

        @Override
        public final Builder accountCustomization(AccountCustomization accountCustomization) {
            this.accountCustomization = accountCustomization;
            return this;
        }

        public final void setAccountCustomization(AccountCustomization.BuilderImpl accountCustomization) {
            this.accountCustomization = accountCustomization != null ? accountCustomization.build() : null;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public UpdateAccountCustomizationResponse build() {
            return new UpdateAccountCustomizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccountCustomizationResponse> {
        public Builder arn(String var1);

        public Builder awsAccountId(String var1);

        public Builder namespace(String var1);

        public Builder accountCustomization(AccountCustomization var1);

        default public Builder accountCustomization(Consumer<AccountCustomization.Builder> accountCustomization) {
            return this.accountCustomization((AccountCustomization)((AccountCustomization.Builder)AccountCustomization.builder().applyMutation(accountCustomization)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

