/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.IdentityType;
import software.amazon.awssdk.services.quicksight.model.UserRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, User> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::arn)).setter(User.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::userName)).setter(User.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::email)).setter(User.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::roleAsString)).setter(User.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::identityTypeAsString)).setter(User.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(User.getter(User::active)).setter(User.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::principalId)).setter(User.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()}).build();
    private static final SdkField<String> CUSTOM_PERMISSIONS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::customPermissionsName)).setter(User.setter(Builder::customPermissionsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissionsName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, USER_NAME_FIELD, EMAIL_FIELD, ROLE_FIELD, IDENTITY_TYPE_FIELD, ACTIVE_FIELD, PRINCIPAL_ID_FIELD, CUSTOM_PERMISSIONS_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String userName;
    private final String email;
    private final String role;
    private final String identityType;
    private final Boolean active;
    private final String principalId;
    private final String customPermissionsName;

    private User(BuilderImpl builder) {
        this.arn = builder.arn;
        this.userName = builder.userName;
        this.email = builder.email;
        this.role = builder.role;
        this.identityType = builder.identityType;
        this.active = builder.active;
        this.principalId = builder.principalId;
        this.customPermissionsName = builder.customPermissionsName;
    }

    public String arn() {
        return this.arn;
    }

    public String userName() {
        return this.userName;
    }

    public String email() {
        return this.email;
    }

    public UserRole role() {
        return UserRole.fromValue(this.role);
    }

    public String roleAsString() {
        return this.role;
    }

    public IdentityType identityType() {
        return IdentityType.fromValue(this.identityType);
    }

    public String identityTypeAsString() {
        return this.identityType;
    }

    public Boolean active() {
        return this.active;
    }

    public String principalId() {
        return this.principalId;
    }

    public String customPermissionsName() {
        return this.customPermissionsName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPermissionsName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(this.active(), other.active()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.customPermissionsName(), other.customPermissionsName());
    }

    public String toString() {
        return ToString.builder((String)"User").add("Arn", (Object)this.arn()).add("UserName", (Object)this.userName()).add("Email", (Object)this.email()).add("Role", (Object)this.roleAsString()).add("IdentityType", (Object)this.identityTypeAsString()).add("Active", (Object)this.active()).add("PrincipalId", (Object)this.principalId()).add("CustomPermissionsName", (Object)this.customPermissionsName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "IdentityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
            case "Active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "CustomPermissionsName": {
                return Optional.ofNullable(clazz.cast(this.customPermissionsName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String userName;
        private String email;
        private String role;
        private String identityType;
        private Boolean active;
        private String principalId;
        private String customPermissionsName;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.arn(model.arn);
            this.userName(model.userName);
            this.email(model.email);
            this.role(model.role);
            this.identityType(model.identityType);
            this.active(model.active);
            this.principalId(model.principalId);
            this.customPermissionsName(model.customPermissionsName);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(UserRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final Boolean getActive() {
            return this.active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getCustomPermissionsName() {
            return this.customPermissionsName;
        }

        @Override
        public final Builder customPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
            return this;
        }

        public final void setCustomPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
        }

        public User build() {
            return new User(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, User> {
        public Builder arn(String var1);

        public Builder userName(String var1);

        public Builder email(String var1);

        public Builder role(String var1);

        public Builder role(UserRole var1);

        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder active(Boolean var1);

        public Builder principalId(String var1);

        public Builder customPermissionsName(String var1);
    }
}

