/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DashboardFilterAttribute {
    QUICKSIGHT_USER("QUICKSIGHT_USER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DashboardFilterAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DashboardFilterAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DashboardFilterAttribute.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DashboardFilterAttribute> knownValues() {
        return Stream.of(DashboardFilterAttribute.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

