/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateUserRequest.Builder, UpdateUserRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserName").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserRequest::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserRequest::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, EMAIL_FIELD, ROLE_FIELD));

    private final String userName;

    private final String awsAccountId;

    private final String namespace;

    private final String email;

    private final String role;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.email = builder.email;
        this.role = builder.role;
    }

    /**
     * <p>
     * The Amazon QuickSight user name that you want to update.
     * </p>
     * 
     * @return The Amazon QuickSight user name that you want to update.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your
     * Amazon QuickSight account.
     * </p>
     * 
     * @return The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that
     *         contains your Amazon QuickSight account.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The namespace. Currently, you should set this to <code>default</code>.
     * </p>
     * 
     * @return The namespace. Currently, you should set this to <code>default</code>.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The email address of the user that you want to update.
     * </p>
     * 
     * @return The email address of the user that you want to update.
     */
    public String email() {
        return email;
    }

    /**
     * <p>
     * The Amazon QuickSight role of the user. The user role can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role of the user. The user role can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     * @see UserRole
     */
    public UserRole role() {
        return UserRole.fromValue(role);
    }

    /**
     * <p>
     * The Amazon QuickSight role of the user. The user role can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role of the user. The user role can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     * @see UserRole
     */
    public String roleAsString() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(email(), other.email())
                && Objects.equals(roleAsString(), other.roleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateUserRequest").add("UserName", userName()).add("AwsAccountId", awsAccountId())
                .add("Namespace", namespace()).add("Email", email()).add("Role", roleAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserRequest> {
        /**
         * <p>
         * The Amazon QuickSight user name that you want to update.
         * </p>
         * 
         * @param userName
         *        The Amazon QuickSight user name that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains
         * your Amazon QuickSight account.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that
         *        contains your Amazon QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The namespace. Currently, you should set this to <code>default</code>.
         * </p>
         * 
         * @param namespace
         *        The namespace. Currently, you should set this to <code>default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The email address of the user that you want to update.
         * </p>
         * 
         * @param email
         *        The email address of the user that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The Amazon QuickSight role of the user. The user role can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * </ul>
         * 
         * @param role
         *        The Amazon QuickSight role of the user. The user role can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(String role);

        /**
         * <p>
         * The Amazon QuickSight role of the user. The user role can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * </ul>
         * 
         * @param role
         *        The Amazon QuickSight role of the user. The user role can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(UserRole role);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String userName;

        private String awsAccountId;

        private String namespace;

        private String email;

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            userName(model.userName);
            awsAccountId(model.awsAccountId);
            namespace(model.namespace);
            email(model.email);
            role(model.role);
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(UserRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
