/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data transformation on a logical table. This is a variant type structure. For this structure to be valid, only one
 * of the attributes can be non-null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformOperation.Builder, TransformOperation> {
    private static final SdkField<ProjectOperation> PROJECT_OPERATION_FIELD = SdkField
            .<ProjectOperation> builder(MarshallingType.SDK_POJO).getter(getter(TransformOperation::projectOperation))
            .setter(setter(Builder::projectOperation)).constructor(ProjectOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectOperation").build()).build();

    private static final SdkField<FilterOperation> FILTER_OPERATION_FIELD = SdkField
            .<FilterOperation> builder(MarshallingType.SDK_POJO).getter(getter(TransformOperation::filterOperation))
            .setter(setter(Builder::filterOperation)).constructor(FilterOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOperation").build()).build();

    private static final SdkField<CreateColumnsOperation> CREATE_COLUMNS_OPERATION_FIELD = SdkField
            .<CreateColumnsOperation> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransformOperation::createColumnsOperation)).setter(setter(Builder::createColumnsOperation))
            .constructor(CreateColumnsOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateColumnsOperation").build())
            .build();

    private static final SdkField<RenameColumnOperation> RENAME_COLUMN_OPERATION_FIELD = SdkField
            .<RenameColumnOperation> builder(MarshallingType.SDK_POJO).getter(getter(TransformOperation::renameColumnOperation))
            .setter(setter(Builder::renameColumnOperation)).constructor(RenameColumnOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameColumnOperation").build())
            .build();

    private static final SdkField<CastColumnTypeOperation> CAST_COLUMN_TYPE_OPERATION_FIELD = SdkField
            .<CastColumnTypeOperation> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransformOperation::castColumnTypeOperation)).setter(setter(Builder::castColumnTypeOperation))
            .constructor(CastColumnTypeOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CastColumnTypeOperation").build())
            .build();

    private static final SdkField<TagColumnOperation> TAG_COLUMN_OPERATION_FIELD = SdkField
            .<TagColumnOperation> builder(MarshallingType.SDK_POJO).getter(getter(TransformOperation::tagColumnOperation))
            .setter(setter(Builder::tagColumnOperation)).constructor(TagColumnOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagColumnOperation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_OPERATION_FIELD,
            FILTER_OPERATION_FIELD, CREATE_COLUMNS_OPERATION_FIELD, RENAME_COLUMN_OPERATION_FIELD,
            CAST_COLUMN_TYPE_OPERATION_FIELD, TAG_COLUMN_OPERATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProjectOperation projectOperation;

    private final FilterOperation filterOperation;

    private final CreateColumnsOperation createColumnsOperation;

    private final RenameColumnOperation renameColumnOperation;

    private final CastColumnTypeOperation castColumnTypeOperation;

    private final TagColumnOperation tagColumnOperation;

    private TransformOperation(BuilderImpl builder) {
        this.projectOperation = builder.projectOperation;
        this.filterOperation = builder.filterOperation;
        this.createColumnsOperation = builder.createColumnsOperation;
        this.renameColumnOperation = builder.renameColumnOperation;
        this.castColumnTypeOperation = builder.castColumnTypeOperation;
        this.tagColumnOperation = builder.tagColumnOperation;
    }

    /**
     * <p>
     * An operation that projects columns. Operations that come after a projection can only refer to projected columns.
     * </p>
     * 
     * @return An operation that projects columns. Operations that come after a projection can only refer to projected
     *         columns.
     */
    public ProjectOperation projectOperation() {
        return projectOperation;
    }

    /**
     * <p>
     * An operation that filters rows based on some condition.
     * </p>
     * 
     * @return An operation that filters rows based on some condition.
     */
    public FilterOperation filterOperation() {
        return filterOperation;
    }

    /**
     * <p>
     * An operation that creates calculated columns. Columns created in one such operation form a lexical closure.
     * </p>
     * 
     * @return An operation that creates calculated columns. Columns created in one such operation form a lexical
     *         closure.
     */
    public CreateColumnsOperation createColumnsOperation() {
        return createColumnsOperation;
    }

    /**
     * <p>
     * An operation that renames a column.
     * </p>
     * 
     * @return An operation that renames a column.
     */
    public RenameColumnOperation renameColumnOperation() {
        return renameColumnOperation;
    }

    /**
     * <p>
     * A transform operation that casts a column to a different type.
     * </p>
     * 
     * @return A transform operation that casts a column to a different type.
     */
    public CastColumnTypeOperation castColumnTypeOperation() {
        return castColumnTypeOperation;
    }

    /**
     * <p>
     * An operation that tags a column with additional information.
     * </p>
     * 
     * @return An operation that tags a column with additional information.
     */
    public TagColumnOperation tagColumnOperation() {
        return tagColumnOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectOperation());
        hashCode = 31 * hashCode + Objects.hashCode(filterOperation());
        hashCode = 31 * hashCode + Objects.hashCode(createColumnsOperation());
        hashCode = 31 * hashCode + Objects.hashCode(renameColumnOperation());
        hashCode = 31 * hashCode + Objects.hashCode(castColumnTypeOperation());
        hashCode = 31 * hashCode + Objects.hashCode(tagColumnOperation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformOperation)) {
            return false;
        }
        TransformOperation other = (TransformOperation) obj;
        return Objects.equals(projectOperation(), other.projectOperation())
                && Objects.equals(filterOperation(), other.filterOperation())
                && Objects.equals(createColumnsOperation(), other.createColumnsOperation())
                && Objects.equals(renameColumnOperation(), other.renameColumnOperation())
                && Objects.equals(castColumnTypeOperation(), other.castColumnTypeOperation())
                && Objects.equals(tagColumnOperation(), other.tagColumnOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransformOperation").add("ProjectOperation", projectOperation())
                .add("FilterOperation", filterOperation()).add("CreateColumnsOperation", createColumnsOperation())
                .add("RenameColumnOperation", renameColumnOperation()).add("CastColumnTypeOperation", castColumnTypeOperation())
                .add("TagColumnOperation", tagColumnOperation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectOperation":
            return Optional.ofNullable(clazz.cast(projectOperation()));
        case "FilterOperation":
            return Optional.ofNullable(clazz.cast(filterOperation()));
        case "CreateColumnsOperation":
            return Optional.ofNullable(clazz.cast(createColumnsOperation()));
        case "RenameColumnOperation":
            return Optional.ofNullable(clazz.cast(renameColumnOperation()));
        case "CastColumnTypeOperation":
            return Optional.ofNullable(clazz.cast(castColumnTypeOperation()));
        case "TagColumnOperation":
            return Optional.ofNullable(clazz.cast(tagColumnOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformOperation, T> g) {
        return obj -> g.apply((TransformOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformOperation> {
        /**
         * <p>
         * An operation that projects columns. Operations that come after a projection can only refer to projected
         * columns.
         * </p>
         * 
         * @param projectOperation
         *        An operation that projects columns. Operations that come after a projection can only refer to
         *        projected columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectOperation(ProjectOperation projectOperation);

        /**
         * <p>
         * An operation that projects columns. Operations that come after a projection can only refer to projected
         * columns.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectOperation.Builder} avoiding the need to
         * create one manually via {@link ProjectOperation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #projectOperation(ProjectOperation)}.
         * 
         * @param projectOperation
         *        a consumer that will call methods on {@link ProjectOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectOperation(ProjectOperation)
         */
        default Builder projectOperation(Consumer<ProjectOperation.Builder> projectOperation) {
            return projectOperation(ProjectOperation.builder().applyMutation(projectOperation).build());
        }

        /**
         * <p>
         * An operation that filters rows based on some condition.
         * </p>
         * 
         * @param filterOperation
         *        An operation that filters rows based on some condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperation(FilterOperation filterOperation);

        /**
         * <p>
         * An operation that filters rows based on some condition.
         * </p>
         * This is a convenience that creates an instance of the {@link FilterOperation.Builder} avoiding the need to
         * create one manually via {@link FilterOperation#builder()}.
         *
         * When the {@link Consumer} completes, {@link FilterOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #filterOperation(FilterOperation)}.
         * 
         * @param filterOperation
         *        a consumer that will call methods on {@link FilterOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterOperation(FilterOperation)
         */
        default Builder filterOperation(Consumer<FilterOperation.Builder> filterOperation) {
            return filterOperation(FilterOperation.builder().applyMutation(filterOperation).build());
        }

        /**
         * <p>
         * An operation that creates calculated columns. Columns created in one such operation form a lexical closure.
         * </p>
         * 
         * @param createColumnsOperation
         *        An operation that creates calculated columns. Columns created in one such operation form a lexical
         *        closure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createColumnsOperation(CreateColumnsOperation createColumnsOperation);

        /**
         * <p>
         * An operation that creates calculated columns. Columns created in one such operation form a lexical closure.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateColumnsOperation.Builder} avoiding the
         * need to create one manually via {@link CreateColumnsOperation#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateColumnsOperation.Builder#build()} is called immediately and
         * its result is passed to {@link #createColumnsOperation(CreateColumnsOperation)}.
         * 
         * @param createColumnsOperation
         *        a consumer that will call methods on {@link CreateColumnsOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createColumnsOperation(CreateColumnsOperation)
         */
        default Builder createColumnsOperation(Consumer<CreateColumnsOperation.Builder> createColumnsOperation) {
            return createColumnsOperation(CreateColumnsOperation.builder().applyMutation(createColumnsOperation).build());
        }

        /**
         * <p>
         * An operation that renames a column.
         * </p>
         * 
         * @param renameColumnOperation
         *        An operation that renames a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renameColumnOperation(RenameColumnOperation renameColumnOperation);

        /**
         * <p>
         * An operation that renames a column.
         * </p>
         * This is a convenience that creates an instance of the {@link RenameColumnOperation.Builder} avoiding the need
         * to create one manually via {@link RenameColumnOperation#builder()}.
         *
         * When the {@link Consumer} completes, {@link RenameColumnOperation.Builder#build()} is called immediately and
         * its result is passed to {@link #renameColumnOperation(RenameColumnOperation)}.
         * 
         * @param renameColumnOperation
         *        a consumer that will call methods on {@link RenameColumnOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renameColumnOperation(RenameColumnOperation)
         */
        default Builder renameColumnOperation(Consumer<RenameColumnOperation.Builder> renameColumnOperation) {
            return renameColumnOperation(RenameColumnOperation.builder().applyMutation(renameColumnOperation).build());
        }

        /**
         * <p>
         * A transform operation that casts a column to a different type.
         * </p>
         * 
         * @param castColumnTypeOperation
         *        A transform operation that casts a column to a different type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder castColumnTypeOperation(CastColumnTypeOperation castColumnTypeOperation);

        /**
         * <p>
         * A transform operation that casts a column to a different type.
         * </p>
         * This is a convenience that creates an instance of the {@link CastColumnTypeOperation.Builder} avoiding the
         * need to create one manually via {@link CastColumnTypeOperation#builder()}.
         *
         * When the {@link Consumer} completes, {@link CastColumnTypeOperation.Builder#build()} is called immediately
         * and its result is passed to {@link #castColumnTypeOperation(CastColumnTypeOperation)}.
         * 
         * @param castColumnTypeOperation
         *        a consumer that will call methods on {@link CastColumnTypeOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #castColumnTypeOperation(CastColumnTypeOperation)
         */
        default Builder castColumnTypeOperation(Consumer<CastColumnTypeOperation.Builder> castColumnTypeOperation) {
            return castColumnTypeOperation(CastColumnTypeOperation.builder().applyMutation(castColumnTypeOperation).build());
        }

        /**
         * <p>
         * An operation that tags a column with additional information.
         * </p>
         * 
         * @param tagColumnOperation
         *        An operation that tags a column with additional information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagColumnOperation(TagColumnOperation tagColumnOperation);

        /**
         * <p>
         * An operation that tags a column with additional information.
         * </p>
         * This is a convenience that creates an instance of the {@link TagColumnOperation.Builder} avoiding the need to
         * create one manually via {@link TagColumnOperation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TagColumnOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #tagColumnOperation(TagColumnOperation)}.
         * 
         * @param tagColumnOperation
         *        a consumer that will call methods on {@link TagColumnOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagColumnOperation(TagColumnOperation)
         */
        default Builder tagColumnOperation(Consumer<TagColumnOperation.Builder> tagColumnOperation) {
            return tagColumnOperation(TagColumnOperation.builder().applyMutation(tagColumnOperation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProjectOperation projectOperation;

        private FilterOperation filterOperation;

        private CreateColumnsOperation createColumnsOperation;

        private RenameColumnOperation renameColumnOperation;

        private CastColumnTypeOperation castColumnTypeOperation;

        private TagColumnOperation tagColumnOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformOperation model) {
            projectOperation(model.projectOperation);
            filterOperation(model.filterOperation);
            createColumnsOperation(model.createColumnsOperation);
            renameColumnOperation(model.renameColumnOperation);
            castColumnTypeOperation(model.castColumnTypeOperation);
            tagColumnOperation(model.tagColumnOperation);
        }

        public final ProjectOperation.Builder getProjectOperation() {
            return projectOperation != null ? projectOperation.toBuilder() : null;
        }

        @Override
        public final Builder projectOperation(ProjectOperation projectOperation) {
            this.projectOperation = projectOperation;
            return this;
        }

        public final void setProjectOperation(ProjectOperation.BuilderImpl projectOperation) {
            this.projectOperation = projectOperation != null ? projectOperation.build() : null;
        }

        public final FilterOperation.Builder getFilterOperation() {
            return filterOperation != null ? filterOperation.toBuilder() : null;
        }

        @Override
        public final Builder filterOperation(FilterOperation filterOperation) {
            this.filterOperation = filterOperation;
            return this;
        }

        public final void setFilterOperation(FilterOperation.BuilderImpl filterOperation) {
            this.filterOperation = filterOperation != null ? filterOperation.build() : null;
        }

        public final CreateColumnsOperation.Builder getCreateColumnsOperation() {
            return createColumnsOperation != null ? createColumnsOperation.toBuilder() : null;
        }

        @Override
        public final Builder createColumnsOperation(CreateColumnsOperation createColumnsOperation) {
            this.createColumnsOperation = createColumnsOperation;
            return this;
        }

        public final void setCreateColumnsOperation(CreateColumnsOperation.BuilderImpl createColumnsOperation) {
            this.createColumnsOperation = createColumnsOperation != null ? createColumnsOperation.build() : null;
        }

        public final RenameColumnOperation.Builder getRenameColumnOperation() {
            return renameColumnOperation != null ? renameColumnOperation.toBuilder() : null;
        }

        @Override
        public final Builder renameColumnOperation(RenameColumnOperation renameColumnOperation) {
            this.renameColumnOperation = renameColumnOperation;
            return this;
        }

        public final void setRenameColumnOperation(RenameColumnOperation.BuilderImpl renameColumnOperation) {
            this.renameColumnOperation = renameColumnOperation != null ? renameColumnOperation.build() : null;
        }

        public final CastColumnTypeOperation.Builder getCastColumnTypeOperation() {
            return castColumnTypeOperation != null ? castColumnTypeOperation.toBuilder() : null;
        }

        @Override
        public final Builder castColumnTypeOperation(CastColumnTypeOperation castColumnTypeOperation) {
            this.castColumnTypeOperation = castColumnTypeOperation;
            return this;
        }

        public final void setCastColumnTypeOperation(CastColumnTypeOperation.BuilderImpl castColumnTypeOperation) {
            this.castColumnTypeOperation = castColumnTypeOperation != null ? castColumnTypeOperation.build() : null;
        }

        public final TagColumnOperation.Builder getTagColumnOperation() {
            return tagColumnOperation != null ? tagColumnOperation.toBuilder() : null;
        }

        @Override
        public final Builder tagColumnOperation(TagColumnOperation tagColumnOperation) {
            this.tagColumnOperation = tagColumnOperation;
            return this;
        }

        public final void setTagColumnOperation(TagColumnOperation.BuilderImpl tagColumnOperation) {
            this.tagColumnOperation = tagColumnOperation != null ? tagColumnOperation.build() : null;
        }

        @Override
        public TransformOperation build() {
            return new TransformOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
