/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupsResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListGroupsResponse.Builder, ListGroupsResponse> {
    private static final SdkField<List<Group>> GROUP_LIST_FIELD = SdkField
            .<List<Group>> builder(MarshallingType.LIST)
            .getter(getter(ListGroupsResponse::groupList))
            .setter(setter(Builder::groupList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Group> builder(MarshallingType.SDK_POJO)
                                            .constructor(Group::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGroupsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListGroupsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_LIST_FIELD,
            NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final List<Group> groupList;

    private final String nextToken;

    private final String requestId;

    private final Integer status;

    private ListGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.groupList = builder.groupList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * Returns true if the GroupList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGroupList() {
        return groupList != null && !(groupList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of the groups.
     */
    public List<Group> groupList() {
        return groupList;
    }

    /**
     * <p>
     * A pagination token that can be used in a subsequent request.
     * </p>
     * 
     * @return A pagination token that can be used in a subsequent request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsResponse)) {
            return false;
        }
        ListGroupsResponse other = (ListGroupsResponse) obj;
        return Objects.equals(groupList(), other.groupList()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListGroupsResponse").add("GroupList", groupList()).add("NextToken", nextToken())
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupList":
            return Optional.ofNullable(clazz.cast(groupList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsResponse, T> g) {
        return obj -> g.apply((ListGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGroupsResponse> {
        /**
         * <p>
         * The list of the groups.
         * </p>
         * 
         * @param groupList
         *        The list of the groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupList(Collection<Group> groupList);

        /**
         * <p>
         * The list of the groups.
         * </p>
         * 
         * @param groupList
         *        The list of the groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupList(Group... groupList);

        /**
         * <p>
         * The list of the groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Group>.Builder} avoiding the need to create
         * one manually via {@link List<Group>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Group>.Builder#build()} is called immediately and its result
         * is passed to {@link #groupList(List<Group>)}.
         * 
         * @param groupList
         *        a consumer that will call methods on {@link List<Group>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupList(List<Group>)
         */
        Builder groupList(Consumer<Group.Builder>... groupList);

        /**
         * <p>
         * A pagination token that can be used in a subsequent request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that can be used in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<Group> groupList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsResponse model) {
            super(model);
            groupList(model.groupList);
            nextToken(model.nextToken);
            requestId(model.requestId);
            status(model.status);
        }

        public final Collection<Group.Builder> getGroupList() {
            return groupList != null ? groupList.stream().map(Group::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groupList(Collection<Group> groupList) {
            this.groupList = GroupListCopier.copy(groupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupList(Group... groupList) {
            groupList(Arrays.asList(groupList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupList(Consumer<Group.Builder>... groupList) {
            groupList(Stream.of(groupList).map(c -> Group.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroupList(Collection<Group.BuilderImpl> groupList) {
            this.groupList = GroupListCopier.copyFromBuilder(groupList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public ListGroupsResponse build() {
            return new ListGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
