/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.JoinType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JoinInstruction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JoinInstruction> {
    private static final SdkField<String> LEFT_OPERAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JoinInstruction.getter(JoinInstruction::leftOperand)).setter(JoinInstruction.setter(Builder::leftOperand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeftOperand").build()}).build();
    private static final SdkField<String> RIGHT_OPERAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JoinInstruction.getter(JoinInstruction::rightOperand)).setter(JoinInstruction.setter(Builder::rightOperand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightOperand").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JoinInstruction.getter(JoinInstruction::typeAsString)).setter(JoinInstruction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ON_CLAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JoinInstruction.getter(JoinInstruction::onClause)).setter(JoinInstruction.setter(Builder::onClause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnClause").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEFT_OPERAND_FIELD, RIGHT_OPERAND_FIELD, TYPE_FIELD, ON_CLAUSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String leftOperand;
    private final String rightOperand;
    private final String type;
    private final String onClause;

    private JoinInstruction(BuilderImpl builder) {
        this.leftOperand = builder.leftOperand;
        this.rightOperand = builder.rightOperand;
        this.type = builder.type;
        this.onClause = builder.onClause;
    }

    public String leftOperand() {
        return this.leftOperand;
    }

    public String rightOperand() {
        return this.rightOperand;
    }

    public JoinType type() {
        return JoinType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String onClause() {
        return this.onClause;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.leftOperand());
        hashCode = 31 * hashCode + Objects.hashCode(this.rightOperand());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.onClause());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinInstruction)) {
            return false;
        }
        JoinInstruction other = (JoinInstruction)obj;
        return Objects.equals(this.leftOperand(), other.leftOperand()) && Objects.equals(this.rightOperand(), other.rightOperand()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.onClause(), other.onClause());
    }

    public String toString() {
        return ToString.builder((String)"JoinInstruction").add("LeftOperand", (Object)this.leftOperand()).add("RightOperand", (Object)this.rightOperand()).add("Type", (Object)this.typeAsString()).add("OnClause", (Object)this.onClause()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LeftOperand": {
                return Optional.ofNullable(clazz.cast(this.leftOperand()));
            }
            case "RightOperand": {
                return Optional.ofNullable(clazz.cast(this.rightOperand()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "OnClause": {
                return Optional.ofNullable(clazz.cast(this.onClause()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JoinInstruction, T> g) {
        return obj -> g.apply((JoinInstruction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String leftOperand;
        private String rightOperand;
        private String type;
        private String onClause;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinInstruction model) {
            this.leftOperand(model.leftOperand);
            this.rightOperand(model.rightOperand);
            this.type(model.type);
            this.onClause(model.onClause);
        }

        public final String getLeftOperand() {
            return this.leftOperand;
        }

        @Override
        public final Builder leftOperand(String leftOperand) {
            this.leftOperand = leftOperand;
            return this;
        }

        public final void setLeftOperand(String leftOperand) {
            this.leftOperand = leftOperand;
        }

        public final String getRightOperand() {
            return this.rightOperand;
        }

        @Override
        public final Builder rightOperand(String rightOperand) {
            this.rightOperand = rightOperand;
            return this;
        }

        public final void setRightOperand(String rightOperand) {
            this.rightOperand = rightOperand;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JoinType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getOnClause() {
            return this.onClause;
        }

        @Override
        public final Builder onClause(String onClause) {
            this.onClause = onClause;
            return this;
        }

        public final void setOnClause(String onClause) {
            this.onClause = onClause;
        }

        public JoinInstruction build() {
            return new JoinInstruction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JoinInstruction> {
        public Builder leftOperand(String var1);

        public Builder rightOperand(String var1);

        public Builder type(String var1);

        public Builder type(JoinType var1);

        public Builder onClause(String var1);
    }
}

