/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSetReference;
import software.amazon.awssdk.services.quicksight.model.DataSetReferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateSourceAnalysis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateSourceAnalysis> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TemplateSourceAnalysis.getter(TemplateSourceAnalysis::arn)).setter(TemplateSourceAnalysis.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<DataSetReference>> DATA_SET_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TemplateSourceAnalysis.getter(TemplateSourceAnalysis::dataSetReferences)).setter(TemplateSourceAnalysis.setter(Builder::dataSetReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_SET_REFERENCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<DataSetReference> dataSetReferences;

    private TemplateSourceAnalysis(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataSetReferences = builder.dataSetReferences;
    }

    public String arn() {
        return this.arn;
    }

    public List<DataSetReference> dataSetReferences() {
        return this.dataSetReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetReferences());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSourceAnalysis)) {
            return false;
        }
        TemplateSourceAnalysis other = (TemplateSourceAnalysis)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataSetReferences(), other.dataSetReferences());
    }

    public String toString() {
        return ToString.builder((String)"TemplateSourceAnalysis").add("Arn", (Object)this.arn()).add("DataSetReferences", this.dataSetReferences()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DataSetReferences": {
                return Optional.ofNullable(clazz.cast(this.dataSetReferences()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateSourceAnalysis, T> g) {
        return obj -> g.apply((TemplateSourceAnalysis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<DataSetReference> dataSetReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSourceAnalysis model) {
            this.arn(model.arn);
            this.dataSetReferences(model.dataSetReferences);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<DataSetReference.Builder> getDataSetReferences() {
            return this.dataSetReferences != null ? (Collection)this.dataSetReferences.stream().map(DataSetReference::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSetReferences(Collection<DataSetReference> dataSetReferences) {
            this.dataSetReferences = DataSetReferenceListCopier.copy(dataSetReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetReferences(DataSetReference ... dataSetReferences) {
            this.dataSetReferences(Arrays.asList(dataSetReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetReferences(Consumer<DataSetReference.Builder> ... dataSetReferences) {
            this.dataSetReferences(Stream.of(dataSetReferences).map(c -> (DataSetReference)((DataSetReference.Builder)DataSetReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataSetReferences(Collection<DataSetReference.BuilderImpl> dataSetReferences) {
            this.dataSetReferences = DataSetReferenceListCopier.copyFromBuilder(dataSetReferences);
        }

        public TemplateSourceAnalysis build() {
            return new TemplateSourceAnalysis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateSourceAnalysis> {
        public Builder arn(String var1);

        public Builder dataSetReferences(Collection<DataSetReference> var1);

        public Builder dataSetReferences(DataSetReference ... var1);

        public Builder dataSetReferences(Consumer<DataSetReference.Builder> ... var1);
    }
}

