/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DashboardErrorType {
    DATA_SET_NOT_FOUND("DATA_SET_NOT_FOUND"),
    INTERNAL_FAILURE("INTERNAL_FAILURE"),
    PARAMETER_VALUE_INCOMPATIBLE("PARAMETER_VALUE_INCOMPATIBLE"),
    PARAMETER_TYPE_INVALID("PARAMETER_TYPE_INVALID"),
    PARAMETER_NOT_FOUND("PARAMETER_NOT_FOUND"),
    COLUMN_TYPE_MISMATCH("COLUMN_TYPE_MISMATCH"),
    COLUMN_GEOGRAPHIC_ROLE_MISMATCH("COLUMN_GEOGRAPHIC_ROLE_MISMATCH"),
    COLUMN_REPLACEMENT_MISSING("COLUMN_REPLACEMENT_MISSING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DashboardErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DashboardErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DashboardErrorType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DashboardErrorType> knownValues() {
        return Stream.of(DashboardErrorType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

