/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommitTransactionRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommitTransactionRequest> {
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionId").getter(CommitTransactionRequest.getter(CommitTransactionRequest::transactionId)).setter(CommitTransactionRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()}).build();
    private static final SdkField<SdkBytes> COMMIT_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CommitDigest").getter(CommitTransactionRequest.getter(CommitTransactionRequest::commitDigest)).setter(CommitTransactionRequest.setter(Builder::commitDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitDigest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_ID_FIELD, COMMIT_DIGEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CommitTransactionRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transactionId;
    private final SdkBytes commitDigest;

    private CommitTransactionRequest(BuilderImpl builder) {
        this.transactionId = builder.transactionId;
        this.commitDigest = builder.commitDigest;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final SdkBytes commitDigest() {
        return this.commitDigest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitDigest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitTransactionRequest)) {
            return false;
        }
        CommitTransactionRequest other = (CommitTransactionRequest)obj;
        return Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.commitDigest(), other.commitDigest());
    }

    public final String toString() {
        return ToString.builder((String)"CommitTransactionRequest").add("TransactionId", (Object)this.transactionId()).add("CommitDigest", (Object)this.commitDigest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "CommitDigest": {
                return Optional.ofNullable(clazz.cast(this.commitDigest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransactionId", TRANSACTION_ID_FIELD);
        map.put("CommitDigest", COMMIT_DIGEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommitTransactionRequest, T> g) {
        return obj -> g.apply((CommitTransactionRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transactionId;
        private SdkBytes commitDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitTransactionRequest model) {
            this.transactionId(model.transactionId);
            this.commitDigest(model.commitDigest);
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final ByteBuffer getCommitDigest() {
            return this.commitDigest == null ? null : this.commitDigest.asByteBuffer();
        }

        public final void setCommitDigest(ByteBuffer commitDigest) {
            this.commitDigest(commitDigest == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)commitDigest));
        }

        @Override
        public final Builder commitDigest(SdkBytes commitDigest) {
            this.commitDigest = commitDigest;
            return this;
        }

        public CommitTransactionRequest build() {
            return new CommitTransactionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommitTransactionRequest> {
        public Builder transactionId(String var1);

        public Builder commitDigest(SdkBytes var1);
    }
}

