/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qldbsession.model.ValueHolder;
import software.amazon.awssdk.services.qldbsession.model.ValueHoldersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Page
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Page> {
    private static final SdkField<List<ValueHolder>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Page.getter(Page::values)).setter(Page.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Page.getter(Page::nextPageToken)).setter(Page.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ValueHolder> values;
    private final String nextPageToken;

    private Page(BuilderImpl builder) {
        this.values = builder.values;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public List<ValueHolder> values() {
        return this.values;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page)obj;
        return Objects.equals(this.values(), other.values()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"Page").add("Values", this.values()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Page, T> g) {
        return obj -> g.apply((Page)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ValueHolder> values = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Page model) {
            this.values(model.values);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ValueHolder.Builder> getValues() {
            return this.values != null ? (Collection)this.values.stream().map(ValueHolder::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder values(Collection<ValueHolder> values) {
            this.values = ValueHoldersCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(ValueHolder ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<ValueHolder.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValues(Collection<ValueHolder.BuilderImpl> values) {
            this.values = ValueHoldersCopier.copyFromBuilder(values);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public Page build() {
            return new Page(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Page> {
        public Builder values(Collection<ValueHolder> var1);

        public Builder values(ValueHolder ... var1);

        public Builder values(Consumer<ValueHolder.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

