/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qldb.QldbAsyncClient;
import software.amazon.awssdk.services.qldb.internal.UserAgentUtils;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsResponse;

public class ListJournalS3ExportsPublisher
implements SdkPublisher<ListJournalS3ExportsResponse> {
    private final QldbAsyncClient client;
    private final ListJournalS3ExportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJournalS3ExportsPublisher(QldbAsyncClient client, ListJournalS3ExportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJournalS3ExportsPublisher(QldbAsyncClient client, ListJournalS3ExportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJournalS3ExportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJournalS3ExportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListJournalS3ExportsResponseFetcher
    implements AsyncPageFetcher<ListJournalS3ExportsResponse> {
        private ListJournalS3ExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListJournalS3ExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJournalS3ExportsResponse> nextPage(ListJournalS3ExportsResponse previousPage) {
            if (previousPage == null) {
                return ListJournalS3ExportsPublisher.this.client.listJournalS3Exports(ListJournalS3ExportsPublisher.this.firstRequest);
            }
            return ListJournalS3ExportsPublisher.this.client.listJournalS3Exports((ListJournalS3ExportsRequest)((Object)ListJournalS3ExportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

