/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qldb.model.PermissionsMode;
import software.amazon.awssdk.services.qldb.model.QldbRequest;
import software.amazon.awssdk.services.qldb.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLedgerRequest
extends QldbRequest
implements ToCopyableBuilder<Builder, CreateLedgerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateLedgerRequest.getter(CreateLedgerRequest::name)).setter(CreateLedgerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateLedgerRequest.getter(CreateLedgerRequest::tags)).setter(CreateLedgerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PERMISSIONS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionsMode").getter(CreateLedgerRequest.getter(CreateLedgerRequest::permissionsModeAsString)).setter(CreateLedgerRequest.setter(Builder::permissionsMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsMode").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(CreateLedgerRequest.getter(CreateLedgerRequest::deletionProtection)).setter(CreateLedgerRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(CreateLedgerRequest.getter(CreateLedgerRequest::kmsKey)).setter(CreateLedgerRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TAGS_FIELD, PERMISSIONS_MODE_FIELD, DELETION_PROTECTION_FIELD, KMS_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("PermissionsMode", PERMISSIONS_MODE_FIELD);
            this.put("DeletionProtection", DELETION_PROTECTION_FIELD);
            this.put("KmsKey", KMS_KEY_FIELD);
        }
    });
    private final String name;
    private final Map<String, String> tags;
    private final String permissionsMode;
    private final Boolean deletionProtection;
    private final String kmsKey;

    private CreateLedgerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.tags = builder.tags;
        this.permissionsMode = builder.permissionsMode;
        this.deletionProtection = builder.deletionProtection;
        this.kmsKey = builder.kmsKey;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final PermissionsMode permissionsMode() {
        return PermissionsMode.fromValue(this.permissionsMode);
    }

    public final String permissionsModeAsString() {
        return this.permissionsMode;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLedgerRequest)) {
            return false;
        }
        CreateLedgerRequest other = (CreateLedgerRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.permissionsModeAsString(), other.permissionsModeAsString()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.kmsKey(), other.kmsKey());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLedgerRequest").add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).add("PermissionsMode", (Object)this.permissionsModeAsString()).add("DeletionProtection", (Object)this.deletionProtection()).add("KmsKey", (Object)this.kmsKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PermissionsMode": {
                return Optional.ofNullable(clazz.cast(this.permissionsModeAsString()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLedgerRequest, T> g) {
        return obj -> g.apply((CreateLedgerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbRequest.BuilderImpl
    implements Builder {
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String permissionsMode;
        private Boolean deletionProtection;
        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLedgerRequest model) {
            super(model);
            this.name(model.name);
            this.tags(model.tags);
            this.permissionsMode(model.permissionsMode);
            this.deletionProtection(model.deletionProtection);
            this.kmsKey(model.kmsKey);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getPermissionsMode() {
            return this.permissionsMode;
        }

        public final void setPermissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
        }

        @Override
        public final Builder permissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
            return this;
        }

        @Override
        public final Builder permissionsMode(PermissionsMode permissionsMode) {
            this.permissionsMode(permissionsMode == null ? null : permissionsMode.toString());
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLedgerRequest build() {
            return new CreateLedgerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QldbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLedgerRequest> {
        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder permissionsMode(String var1);

        public Builder permissionsMode(PermissionsMode var1);

        public Builder deletionProtection(Boolean var1);

        public Builder kmsKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

