/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.ExportStatus;
import software.amazon.awssdk.services.qldb.model.OutputFormat;
import software.amazon.awssdk.services.qldb.model.S3ExportConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JournalS3ExportDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JournalS3ExportDescription> {
    private static final SdkField<String> LEDGER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LedgerName").getter(JournalS3ExportDescription.getter(JournalS3ExportDescription::ledgerName)).setter(JournalS3ExportDescription.setter(Builder::ledgerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LedgerName").build()}).build();
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportId").getter(JournalS3ExportDescription.getter(JournalS3ExportDescription::exportId)).setter(JournalS3ExportDescription.setter(Builder::exportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportId").build()}).build();
    private static final SdkField<Instant> EXPORT_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExportCreationTime").getter(JournalS3ExportDescription.getter(JournalS3ExportDescription::exportCreationTime)).setter(JournalS3ExportDescription.setter(Builder::exportCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportCreationTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(JournalS3ExportDescription.getter(JournalS3ExportDescription::statusAsString)).setter(JournalS3ExportDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> INCLUSIVE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InclusiveStartTime").getter(JournalS3ExportDescription.getter(JournalS3ExportDescription::inclusiveStartTime)).setter(JournalS3ExportDescription.setter(Builder::inclusiveStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusiveStartTime").build()}).build();
    private static final SdkField<Instant> EXCLUSIVE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExclusiveEndTime").getter(JournalS3ExportDescription.getter(JournalS3ExportDescription::exclusiveEndTime)).setter(JournalS3ExportDescription.setter(Builder::exclusiveEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveEndTime").build()}).build();
    private static final SdkField<S3ExportConfiguration> S3_EXPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ExportConfiguration").getter(JournalS3ExportDescription.getter(JournalS3ExportDescription::s3ExportConfiguration)).setter(JournalS3ExportDescription.setter(Builder::s3ExportConfiguration)).constructor(S3ExportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(JournalS3ExportDescription.getter(JournalS3ExportDescription::roleArn)).setter(JournalS3ExportDescription.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(JournalS3ExportDescription.getter(JournalS3ExportDescription::outputFormatAsString)).setter(JournalS3ExportDescription.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEDGER_NAME_FIELD, EXPORT_ID_FIELD, EXPORT_CREATION_TIME_FIELD, STATUS_FIELD, INCLUSIVE_START_TIME_FIELD, EXCLUSIVE_END_TIME_FIELD, S3_EXPORT_CONFIGURATION_FIELD, ROLE_ARN_FIELD, OUTPUT_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JournalS3ExportDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ledgerName;
    private final String exportId;
    private final Instant exportCreationTime;
    private final String status;
    private final Instant inclusiveStartTime;
    private final Instant exclusiveEndTime;
    private final S3ExportConfiguration s3ExportConfiguration;
    private final String roleArn;
    private final String outputFormat;

    private JournalS3ExportDescription(BuilderImpl builder) {
        this.ledgerName = builder.ledgerName;
        this.exportId = builder.exportId;
        this.exportCreationTime = builder.exportCreationTime;
        this.status = builder.status;
        this.inclusiveStartTime = builder.inclusiveStartTime;
        this.exclusiveEndTime = builder.exclusiveEndTime;
        this.s3ExportConfiguration = builder.s3ExportConfiguration;
        this.roleArn = builder.roleArn;
        this.outputFormat = builder.outputFormat;
    }

    public final String ledgerName() {
        return this.ledgerName;
    }

    public final String exportId() {
        return this.exportId;
    }

    public final Instant exportCreationTime() {
        return this.exportCreationTime;
    }

    public final ExportStatus status() {
        return ExportStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant inclusiveStartTime() {
        return this.inclusiveStartTime;
    }

    public final Instant exclusiveEndTime() {
        return this.exclusiveEndTime;
    }

    public final S3ExportConfiguration s3ExportConfiguration() {
        return this.s3ExportConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ledgerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusiveStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JournalS3ExportDescription)) {
            return false;
        }
        JournalS3ExportDescription other = (JournalS3ExportDescription)obj;
        return Objects.equals(this.ledgerName(), other.ledgerName()) && Objects.equals(this.exportId(), other.exportId()) && Objects.equals(this.exportCreationTime(), other.exportCreationTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.inclusiveStartTime(), other.inclusiveStartTime()) && Objects.equals(this.exclusiveEndTime(), other.exclusiveEndTime()) && Objects.equals(this.s3ExportConfiguration(), other.s3ExportConfiguration()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JournalS3ExportDescription").add("LedgerName", (Object)this.ledgerName()).add("ExportId", (Object)this.exportId()).add("ExportCreationTime", (Object)this.exportCreationTime()).add("Status", (Object)this.statusAsString()).add("InclusiveStartTime", (Object)this.inclusiveStartTime()).add("ExclusiveEndTime", (Object)this.exclusiveEndTime()).add("S3ExportConfiguration", (Object)this.s3ExportConfiguration()).add("RoleArn", (Object)this.roleArn()).add("OutputFormat", (Object)this.outputFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LedgerName": {
                return Optional.ofNullable(clazz.cast(this.ledgerName()));
            }
            case "ExportId": {
                return Optional.ofNullable(clazz.cast(this.exportId()));
            }
            case "ExportCreationTime": {
                return Optional.ofNullable(clazz.cast(this.exportCreationTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "InclusiveStartTime": {
                return Optional.ofNullable(clazz.cast(this.inclusiveStartTime()));
            }
            case "ExclusiveEndTime": {
                return Optional.ofNullable(clazz.cast(this.exclusiveEndTime()));
            }
            case "S3ExportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3ExportConfiguration()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LedgerName", LEDGER_NAME_FIELD);
        map.put("ExportId", EXPORT_ID_FIELD);
        map.put("ExportCreationTime", EXPORT_CREATION_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("InclusiveStartTime", INCLUSIVE_START_TIME_FIELD);
        map.put("ExclusiveEndTime", EXCLUSIVE_END_TIME_FIELD);
        map.put("S3ExportConfiguration", S3_EXPORT_CONFIGURATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JournalS3ExportDescription, T> g) {
        return obj -> g.apply((JournalS3ExportDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ledgerName;
        private String exportId;
        private Instant exportCreationTime;
        private String status;
        private Instant inclusiveStartTime;
        private Instant exclusiveEndTime;
        private S3ExportConfiguration s3ExportConfiguration;
        private String roleArn;
        private String outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(JournalS3ExportDescription model) {
            this.ledgerName(model.ledgerName);
            this.exportId(model.exportId);
            this.exportCreationTime(model.exportCreationTime);
            this.status(model.status);
            this.inclusiveStartTime(model.inclusiveStartTime);
            this.exclusiveEndTime(model.exclusiveEndTime);
            this.s3ExportConfiguration(model.s3ExportConfiguration);
            this.roleArn(model.roleArn);
            this.outputFormat(model.outputFormat);
        }

        public final String getLedgerName() {
            return this.ledgerName;
        }

        public final void setLedgerName(String ledgerName) {
            this.ledgerName = ledgerName;
        }

        @Override
        public final Builder ledgerName(String ledgerName) {
            this.ledgerName = ledgerName;
            return this;
        }

        public final String getExportId() {
            return this.exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final Instant getExportCreationTime() {
            return this.exportCreationTime;
        }

        public final void setExportCreationTime(Instant exportCreationTime) {
            this.exportCreationTime = exportCreationTime;
        }

        @Override
        public final Builder exportCreationTime(Instant exportCreationTime) {
            this.exportCreationTime = exportCreationTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getInclusiveStartTime() {
            return this.inclusiveStartTime;
        }

        public final void setInclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
        }

        @Override
        public final Builder inclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
            return this;
        }

        public final Instant getExclusiveEndTime() {
            return this.exclusiveEndTime;
        }

        public final void setExclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
        }

        @Override
        public final Builder exclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
            return this;
        }

        public final S3ExportConfiguration.Builder getS3ExportConfiguration() {
            return this.s3ExportConfiguration != null ? this.s3ExportConfiguration.toBuilder() : null;
        }

        public final void setS3ExportConfiguration(S3ExportConfiguration.BuilderImpl s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration != null ? s3ExportConfiguration.build() : null;
        }

        @Override
        public final Builder s3ExportConfiguration(S3ExportConfiguration s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public JournalS3ExportDescription build() {
            return new JournalS3ExportDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JournalS3ExportDescription> {
        public Builder ledgerName(String var1);

        public Builder exportId(String var1);

        public Builder exportCreationTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ExportStatus var1);

        public Builder inclusiveStartTime(Instant var1);

        public Builder exclusiveEndTime(Instant var1);

        public Builder s3ExportConfiguration(S3ExportConfiguration var1);

        default public Builder s3ExportConfiguration(Consumer<S3ExportConfiguration.Builder> s3ExportConfiguration) {
            return this.s3ExportConfiguration((S3ExportConfiguration)((S3ExportConfiguration.Builder)S3ExportConfiguration.builder().applyMutation(s3ExportConfiguration)).build());
        }

        public Builder roleArn(String var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);
    }
}

