/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qldb.QldbClient;
import software.amazon.awssdk.services.qldb.model.ListLedgersRequest;
import software.amazon.awssdk.services.qldb.model.ListLedgersResponse;

public class ListLedgersIterable
implements SdkIterable<ListLedgersResponse> {
    private final QldbClient client;
    private final ListLedgersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLedgersIterable(QldbClient client, ListLedgersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLedgersResponseFetcher();
    }

    public Iterator<ListLedgersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLedgersResponseFetcher
    implements SyncPageFetcher<ListLedgersResponse> {
        private ListLedgersResponseFetcher() {
        }

        public boolean hasNextPage(ListLedgersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLedgersResponse nextPage(ListLedgersResponse previousPage) {
            if (previousPage == null) {
                return ListLedgersIterable.this.client.listLedgers(ListLedgersIterable.this.firstRequest);
            }
            return ListLedgersIterable.this.client.listLedgers((ListLedgersRequest)((Object)ListLedgersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

