/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateSearchResultData;
import software.amazon.awssdk.services.qconnect.model.SearchMessageTemplatesRequest;
import software.amazon.awssdk.services.qconnect.model.SearchMessageTemplatesResponse;

public class SearchMessageTemplatesPublisher
implements SdkPublisher<SearchMessageTemplatesResponse> {
    private final QConnectAsyncClient client;
    private final SearchMessageTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchMessageTemplatesPublisher(QConnectAsyncClient client, SearchMessageTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchMessageTemplatesPublisher(QConnectAsyncClient client, SearchMessageTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchMessageTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchMessageTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MessageTemplateSearchResultData> results() {
        Function<SearchMessageTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchMessageTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchMessageTemplatesResponseFetcher
    implements AsyncPageFetcher<SearchMessageTemplatesResponse> {
        private SearchMessageTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(SearchMessageTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchMessageTemplatesResponse> nextPage(SearchMessageTemplatesResponse previousPage) {
            if (previousPage == null) {
                return SearchMessageTemplatesPublisher.this.client.searchMessageTemplates(SearchMessageTemplatesPublisher.this.firstRequest);
            }
            return SearchMessageTemplatesPublisher.this.client.searchMessageTemplates((SearchMessageTemplatesRequest)((Object)SearchMessageTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

