/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.ListSpansRequest;
import software.amazon.awssdk.services.qconnect.model.ListSpansResponse;
import software.amazon.awssdk.services.qconnect.model.Span;

public class ListSpansIterable
implements SdkIterable<ListSpansResponse> {
    private final QConnectClient client;
    private final ListSpansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSpansIterable(QConnectClient client, ListSpansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSpansResponseFetcher();
    }

    public Iterator<ListSpansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Span> spans() {
        Function<ListSpansResponse, Iterator> getIterator = response -> {
            if (response != null && response.spans() != null) {
                return response.spans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSpansResponseFetcher
    implements SyncPageFetcher<ListSpansResponse> {
        private ListSpansResponseFetcher() {
        }

        public boolean hasNextPage(ListSpansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSpansResponse nextPage(ListSpansResponse previousPage) {
            if (previousPage == null) {
                return ListSpansIterable.this.client.listSpans(ListSpansIterable.this.firstRequest);
            }
            return ListSpansIterable.this.client.listSpans((ListSpansRequest)((Object)ListSpansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

