/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIPromptSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse;

public class ListAIPromptsIterable
implements SdkIterable<ListAiPromptsResponse> {
    private final QConnectClient client;
    private final ListAiPromptsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAIPromptsIterable(QConnectClient client, ListAiPromptsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAiPromptsResponseFetcher();
    }

    public Iterator<ListAiPromptsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AIPromptSummary> aiPromptSummaries() {
        Function<ListAiPromptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiPromptSummaries() != null) {
                return response.aiPromptSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAiPromptsResponseFetcher
    implements SyncPageFetcher<ListAiPromptsResponse> {
        private ListAiPromptsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiPromptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAiPromptsResponse nextPage(ListAiPromptsResponse previousPage) {
            if (previousPage == null) {
                return ListAIPromptsIterable.this.client.listAIPrompts(ListAIPromptsIterable.this.firstRequest);
            }
            return ListAIPromptsIterable.this.client.listAIPrompts((ListAiPromptsRequest)((Object)ListAIPromptsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

