/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.WhatsAppMessageTemplateComponentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WhatsAppMessageTemplateSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WhatsAppMessageTemplateSourceConfiguration> {
    private static final SdkField<String> BUSINESS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("businessAccountId").getter(WhatsAppMessageTemplateSourceConfiguration.getter(WhatsAppMessageTemplateSourceConfiguration::businessAccountId)).setter(WhatsAppMessageTemplateSourceConfiguration.setter(Builder::businessAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessAccountId").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateId").getter(WhatsAppMessageTemplateSourceConfiguration.getter(WhatsAppMessageTemplateSourceConfiguration::templateId)).setter(WhatsAppMessageTemplateSourceConfiguration.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()}).build();
    private static final SdkField<List<String>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("components").getter(WhatsAppMessageTemplateSourceConfiguration.getter(WhatsAppMessageTemplateSourceConfiguration::components)).setter(WhatsAppMessageTemplateSourceConfiguration.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_ACCOUNT_ID_FIELD, TEMPLATE_ID_FIELD, COMPONENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WhatsAppMessageTemplateSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String businessAccountId;
    private final String templateId;
    private final List<String> components;

    private WhatsAppMessageTemplateSourceConfiguration(BuilderImpl builder) {
        this.businessAccountId = builder.businessAccountId;
        this.templateId = builder.templateId;
        this.components = builder.components;
    }

    public final String businessAccountId() {
        return this.businessAccountId;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructList);
    }

    public final List<String> components() {
        return this.components;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.businessAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatsAppMessageTemplateSourceConfiguration)) {
            return false;
        }
        WhatsAppMessageTemplateSourceConfiguration other = (WhatsAppMessageTemplateSourceConfiguration)obj;
        return Objects.equals(this.businessAccountId(), other.businessAccountId()) && Objects.equals(this.templateId(), other.templateId()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components());
    }

    public final String toString() {
        return ToString.builder((String)"WhatsAppMessageTemplateSourceConfiguration").add("BusinessAccountId", (Object)this.businessAccountId()).add("TemplateId", (Object)this.templateId()).add("Components", this.hasComponents() ? this.components() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "businessAccountId": {
                return Optional.ofNullable(clazz.cast(this.businessAccountId()));
            }
            case "templateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessAccountId", BUSINESS_ACCOUNT_ID_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        map.put("components", COMPONENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WhatsAppMessageTemplateSourceConfiguration, T> g) {
        return obj -> g.apply((WhatsAppMessageTemplateSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String businessAccountId;
        private String templateId;
        private List<String> components = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WhatsAppMessageTemplateSourceConfiguration model) {
            this.businessAccountId(model.businessAccountId);
            this.templateId(model.templateId);
            this.components(model.components);
        }

        public final String getBusinessAccountId() {
            return this.businessAccountId;
        }

        public final void setBusinessAccountId(String businessAccountId) {
            this.businessAccountId = businessAccountId;
        }

        @Override
        public final Builder businessAccountId(String businessAccountId) {
            this.businessAccountId = businessAccountId;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final Collection<String> getComponents() {
            if (this.components instanceof SdkAutoConstructList) {
                return null;
            }
            return this.components;
        }

        public final void setComponents(Collection<String> components) {
            this.components = WhatsAppMessageTemplateComponentsCopier.copy(components);
        }

        @Override
        public final Builder components(Collection<String> components) {
            this.components = WhatsAppMessageTemplateComponentsCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(String ... components) {
            this.components(Arrays.asList(components));
            return this;
        }

        public WhatsAppMessageTemplateSourceConfiguration build() {
            return new WhatsAppMessageTemplateSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WhatsAppMessageTemplateSourceConfiguration> {
        public Builder businessAccountId(String var1);

        public Builder templateId(String var1);

        public Builder components(Collection<String> var1);

        public Builder components(String ... var1);
    }
}

