/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.AIAgentConfigurationData;
import software.amazon.awssdk.services.qconnect.model.AIAgentType;
import software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationEntry;
import software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationListCopier;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssistantAiAgentRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, UpdateAssistantAiAgentRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(UpdateAssistantAiAgentRequest.getter(UpdateAssistantAiAgentRequest::assistantId)).setter(UpdateAssistantAiAgentRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> AI_AGENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentType").getter(UpdateAssistantAiAgentRequest.getter(UpdateAssistantAiAgentRequest::aiAgentTypeAsString)).setter(UpdateAssistantAiAgentRequest.setter(Builder::aiAgentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentType").build()}).build();
    private static final SdkField<AIAgentConfigurationData> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateAssistantAiAgentRequest.getter(UpdateAssistantAiAgentRequest::configuration)).setter(UpdateAssistantAiAgentRequest.setter(Builder::configuration)).constructor(AIAgentConfigurationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<List<OrchestratorConfigurationEntry>> ORCHESTRATOR_CONFIGURATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orchestratorConfigurationList").getter(UpdateAssistantAiAgentRequest.getter(UpdateAssistantAiAgentRequest::orchestratorConfigurationList)).setter(UpdateAssistantAiAgentRequest.setter(Builder::orchestratorConfigurationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestratorConfigurationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrchestratorConfigurationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, AI_AGENT_TYPE_FIELD, CONFIGURATION_FIELD, ORCHESTRATOR_CONFIGURATION_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAssistantAiAgentRequest.memberNameToFieldInitializer();
    private final String assistantId;
    private final String aiAgentType;
    private final AIAgentConfigurationData configuration;
    private final List<OrchestratorConfigurationEntry> orchestratorConfigurationList;

    private UpdateAssistantAiAgentRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.aiAgentType = builder.aiAgentType;
        this.configuration = builder.configuration;
        this.orchestratorConfigurationList = builder.orchestratorConfigurationList;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final AIAgentType aiAgentType() {
        return AIAgentType.fromValue(this.aiAgentType);
    }

    public final String aiAgentTypeAsString() {
        return this.aiAgentType;
    }

    public final AIAgentConfigurationData configuration() {
        return this.configuration;
    }

    public final boolean hasOrchestratorConfigurationList() {
        return this.orchestratorConfigurationList != null && !(this.orchestratorConfigurationList instanceof SdkAutoConstructList);
    }

    public final List<OrchestratorConfigurationEntry> orchestratorConfigurationList() {
        return this.orchestratorConfigurationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrchestratorConfigurationList() ? this.orchestratorConfigurationList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssistantAiAgentRequest)) {
            return false;
        }
        UpdateAssistantAiAgentRequest other = (UpdateAssistantAiAgentRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.aiAgentTypeAsString(), other.aiAgentTypeAsString()) && Objects.equals(this.configuration(), other.configuration()) && this.hasOrchestratorConfigurationList() == other.hasOrchestratorConfigurationList() && Objects.equals(this.orchestratorConfigurationList(), other.orchestratorConfigurationList());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAssistantAiAgentRequest").add("AssistantId", (Object)this.assistantId()).add("AiAgentType", (Object)this.aiAgentTypeAsString()).add("Configuration", (Object)this.configuration()).add("OrchestratorConfigurationList", this.hasOrchestratorConfigurationList() ? this.orchestratorConfigurationList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "aiAgentType": {
                return Optional.ofNullable(clazz.cast(this.aiAgentTypeAsString()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "orchestratorConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.orchestratorConfigurationList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("aiAgentType", AI_AGENT_TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("orchestratorConfigurationList", ORCHESTRATOR_CONFIGURATION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssistantAiAgentRequest, T> g) {
        return obj -> g.apply((UpdateAssistantAiAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private String aiAgentType;
        private AIAgentConfigurationData configuration;
        private List<OrchestratorConfigurationEntry> orchestratorConfigurationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssistantAiAgentRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.aiAgentType(model.aiAgentType);
            this.configuration(model.configuration);
            this.orchestratorConfigurationList(model.orchestratorConfigurationList);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAiAgentType() {
            return this.aiAgentType;
        }

        public final void setAiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
        }

        @Override
        public final Builder aiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
            return this;
        }

        @Override
        public final Builder aiAgentType(AIAgentType aiAgentType) {
            this.aiAgentType(aiAgentType == null ? null : aiAgentType.toString());
            return this;
        }

        public final AIAgentConfigurationData.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AIAgentConfigurationData.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AIAgentConfigurationData configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<OrchestratorConfigurationEntry.Builder> getOrchestratorConfigurationList() {
            List<OrchestratorConfigurationEntry.Builder> result = OrchestratorConfigurationListCopier.copyToBuilder(this.orchestratorConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrchestratorConfigurationList(Collection<OrchestratorConfigurationEntry.BuilderImpl> orchestratorConfigurationList) {
            this.orchestratorConfigurationList = OrchestratorConfigurationListCopier.copyFromBuilder(orchestratorConfigurationList);
        }

        @Override
        public final Builder orchestratorConfigurationList(Collection<OrchestratorConfigurationEntry> orchestratorConfigurationList) {
            this.orchestratorConfigurationList = OrchestratorConfigurationListCopier.copy(orchestratorConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orchestratorConfigurationList(OrchestratorConfigurationEntry ... orchestratorConfigurationList) {
            this.orchestratorConfigurationList(Arrays.asList(orchestratorConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orchestratorConfigurationList(Consumer<OrchestratorConfigurationEntry.Builder> ... orchestratorConfigurationList) {
            this.orchestratorConfigurationList(Stream.of(orchestratorConfigurationList).map(c -> (OrchestratorConfigurationEntry)((OrchestratorConfigurationEntry.Builder)OrchestratorConfigurationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssistantAiAgentRequest build() {
            return new UpdateAssistantAiAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssistantAiAgentRequest> {
        public Builder assistantId(String var1);

        public Builder aiAgentType(String var1);

        public Builder aiAgentType(AIAgentType var1);

        public Builder configuration(AIAgentConfigurationData var1);

        default public Builder configuration(Consumer<AIAgentConfigurationData.Builder> configuration) {
            return this.configuration((AIAgentConfigurationData)((AIAgentConfigurationData.Builder)AIAgentConfigurationData.builder().applyMutation(configuration)).build());
        }

        public Builder orchestratorConfigurationList(Collection<OrchestratorConfigurationEntry> var1);

        public Builder orchestratorConfigurationList(OrchestratorConfigurationEntry ... var1);

        public Builder orchestratorConfigurationList(Consumer<OrchestratorConfigurationEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

