/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ToolType {
    MODEL_CONTEXT_PROTOCOL("MODEL_CONTEXT_PROTOCOL"),
    RETURN_TO_CONTROL("RETURN_TO_CONTROL"),
    CONSTANT("CONSTANT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ToolType> VALUE_MAP;
    private final String value;

    private ToolType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ToolType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ToolType> knownValues() {
        EnumSet<ToolType> knownValues = EnumSet.allOf(ToolType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ToolType.class, ToolType::toString);
    }
}

