/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.Annotation;
import software.amazon.awssdk.services.qconnect.model.ToolInstruction;
import software.amazon.awssdk.services.qconnect.model.ToolOutputFilter;
import software.amazon.awssdk.services.qconnect.model.ToolOutputFilterListCopier;
import software.amazon.awssdk.services.qconnect.model.ToolOverrideInputValue;
import software.amazon.awssdk.services.qconnect.model.ToolOverrideInputValueListCopier;
import software.amazon.awssdk.services.qconnect.model.ToolType;
import software.amazon.awssdk.services.qconnect.model.UserInteractionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolConfiguration> {
    private static final SdkField<String> TOOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("toolName").getter(ToolConfiguration.getter(ToolConfiguration::toolName)).setter(ToolConfiguration.setter(Builder::toolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolName").build()}).build();
    private static final SdkField<String> TOOL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("toolType").getter(ToolConfiguration.getter(ToolConfiguration::toolTypeAsString)).setter(ToolConfiguration.setter(Builder::toolType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolType").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(ToolConfiguration.getter(ToolConfiguration::title)).setter(ToolConfiguration.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> TOOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("toolId").getter(ToolConfiguration.getter(ToolConfiguration::toolId)).setter(ToolConfiguration.setter(Builder::toolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ToolConfiguration.getter(ToolConfiguration::description)).setter(ToolConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<ToolInstruction> INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instruction").getter(ToolConfiguration.getter(ToolConfiguration::instruction)).setter(ToolConfiguration.setter(Builder::instruction)).constructor(ToolInstruction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()}).build();
    private static final SdkField<List<ToolOverrideInputValue>> OVERRIDE_INPUT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("overrideInputValues").getter(ToolConfiguration.getter(ToolConfiguration::overrideInputValues)).setter(ToolConfiguration.setter(Builder::overrideInputValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideInputValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ToolOverrideInputValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ToolOutputFilter>> OUTPUT_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputFilters").getter(ToolConfiguration.getter(ToolConfiguration::outputFilters)).setter(ToolConfiguration.setter(Builder::outputFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ToolOutputFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Document> INPUT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("inputSchema").getter(ToolConfiguration.getter(ToolConfiguration::inputSchema)).setter(ToolConfiguration.setter(Builder::inputSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSchema").build()}).build();
    private static final SdkField<Document> OUTPUT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("outputSchema").getter(ToolConfiguration.getter(ToolConfiguration::outputSchema)).setter(ToolConfiguration.setter(Builder::outputSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSchema").build()}).build();
    private static final SdkField<Annotation> ANNOTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("annotations").getter(ToolConfiguration.getter(ToolConfiguration::annotations)).setter(ToolConfiguration.setter(Builder::annotations)).constructor(Annotation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotations").build()}).build();
    private static final SdkField<UserInteractionConfiguration> USER_INTERACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userInteractionConfiguration").getter(ToolConfiguration.getter(ToolConfiguration::userInteractionConfiguration)).setter(ToolConfiguration.setter(Builder::userInteractionConfiguration)).constructor(UserInteractionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userInteractionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_NAME_FIELD, TOOL_TYPE_FIELD, TITLE_FIELD, TOOL_ID_FIELD, DESCRIPTION_FIELD, INSTRUCTION_FIELD, OVERRIDE_INPUT_VALUES_FIELD, OUTPUT_FILTERS_FIELD, INPUT_SCHEMA_FIELD, OUTPUT_SCHEMA_FIELD, ANNOTATIONS_FIELD, USER_INTERACTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ToolConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String toolName;
    private final String toolType;
    private final String title;
    private final String toolId;
    private final String description;
    private final ToolInstruction instruction;
    private final List<ToolOverrideInputValue> overrideInputValues;
    private final List<ToolOutputFilter> outputFilters;
    private final Document inputSchema;
    private final Document outputSchema;
    private final Annotation annotations;
    private final UserInteractionConfiguration userInteractionConfiguration;

    private ToolConfiguration(BuilderImpl builder) {
        this.toolName = builder.toolName;
        this.toolType = builder.toolType;
        this.title = builder.title;
        this.toolId = builder.toolId;
        this.description = builder.description;
        this.instruction = builder.instruction;
        this.overrideInputValues = builder.overrideInputValues;
        this.outputFilters = builder.outputFilters;
        this.inputSchema = builder.inputSchema;
        this.outputSchema = builder.outputSchema;
        this.annotations = builder.annotations;
        this.userInteractionConfiguration = builder.userInteractionConfiguration;
    }

    public final String toolName() {
        return this.toolName;
    }

    public final ToolType toolType() {
        return ToolType.fromValue(this.toolType);
    }

    public final String toolTypeAsString() {
        return this.toolType;
    }

    public final String title() {
        return this.title;
    }

    public final String toolId() {
        return this.toolId;
    }

    public final String description() {
        return this.description;
    }

    public final ToolInstruction instruction() {
        return this.instruction;
    }

    public final boolean hasOverrideInputValues() {
        return this.overrideInputValues != null && !(this.overrideInputValues instanceof SdkAutoConstructList);
    }

    public final List<ToolOverrideInputValue> overrideInputValues() {
        return this.overrideInputValues;
    }

    public final boolean hasOutputFilters() {
        return this.outputFilters != null && !(this.outputFilters instanceof SdkAutoConstructList);
    }

    public final List<ToolOutputFilter> outputFilters() {
        return this.outputFilters;
    }

    public final Document inputSchema() {
        return this.inputSchema;
    }

    public final Document outputSchema() {
        return this.outputSchema;
    }

    public final Annotation annotations() {
        return this.annotations;
    }

    public final UserInteractionConfiguration userInteractionConfiguration() {
        return this.userInteractionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.toolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrideInputValues() ? this.overrideInputValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputFilters() ? this.outputFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotations());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInteractionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolConfiguration)) {
            return false;
        }
        ToolConfiguration other = (ToolConfiguration)obj;
        return Objects.equals(this.toolName(), other.toolName()) && Objects.equals(this.toolTypeAsString(), other.toolTypeAsString()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.toolId(), other.toolId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.instruction(), other.instruction()) && this.hasOverrideInputValues() == other.hasOverrideInputValues() && Objects.equals(this.overrideInputValues(), other.overrideInputValues()) && this.hasOutputFilters() == other.hasOutputFilters() && Objects.equals(this.outputFilters(), other.outputFilters()) && Objects.equals(this.inputSchema(), other.inputSchema()) && Objects.equals(this.outputSchema(), other.outputSchema()) && Objects.equals(this.annotations(), other.annotations()) && Objects.equals(this.userInteractionConfiguration(), other.userInteractionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ToolConfiguration").add("ToolName", (Object)this.toolName()).add("ToolType", (Object)this.toolTypeAsString()).add("Title", (Object)this.title()).add("ToolId", (Object)this.toolId()).add("Description", (Object)this.description()).add("Instruction", (Object)this.instruction()).add("OverrideInputValues", this.hasOverrideInputValues() ? this.overrideInputValues() : null).add("OutputFilters", this.hasOutputFilters() ? this.outputFilters() : null).add("InputSchema", (Object)this.inputSchema()).add("OutputSchema", (Object)this.outputSchema()).add("Annotations", (Object)this.annotations()).add("UserInteractionConfiguration", (Object)this.userInteractionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "toolName": {
                return Optional.ofNullable(clazz.cast(this.toolName()));
            }
            case "toolType": {
                return Optional.ofNullable(clazz.cast(this.toolTypeAsString()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "toolId": {
                return Optional.ofNullable(clazz.cast(this.toolId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "instruction": {
                return Optional.ofNullable(clazz.cast(this.instruction()));
            }
            case "overrideInputValues": {
                return Optional.ofNullable(clazz.cast(this.overrideInputValues()));
            }
            case "outputFilters": {
                return Optional.ofNullable(clazz.cast(this.outputFilters()));
            }
            case "inputSchema": {
                return Optional.ofNullable(clazz.cast(this.inputSchema()));
            }
            case "outputSchema": {
                return Optional.ofNullable(clazz.cast(this.outputSchema()));
            }
            case "annotations": {
                return Optional.ofNullable(clazz.cast(this.annotations()));
            }
            case "userInteractionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.userInteractionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("toolName", TOOL_NAME_FIELD);
        map.put("toolType", TOOL_TYPE_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("toolId", TOOL_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("overrideInputValues", OVERRIDE_INPUT_VALUES_FIELD);
        map.put("outputFilters", OUTPUT_FILTERS_FIELD);
        map.put("inputSchema", INPUT_SCHEMA_FIELD);
        map.put("outputSchema", OUTPUT_SCHEMA_FIELD);
        map.put("annotations", ANNOTATIONS_FIELD);
        map.put("userInteractionConfiguration", USER_INTERACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolConfiguration, T> g) {
        return obj -> g.apply((ToolConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String toolName;
        private String toolType;
        private String title;
        private String toolId;
        private String description;
        private ToolInstruction instruction;
        private List<ToolOverrideInputValue> overrideInputValues = DefaultSdkAutoConstructList.getInstance();
        private List<ToolOutputFilter> outputFilters = DefaultSdkAutoConstructList.getInstance();
        private Document inputSchema;
        private Document outputSchema;
        private Annotation annotations;
        private UserInteractionConfiguration userInteractionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolConfiguration model) {
            this.toolName(model.toolName);
            this.toolType(model.toolType);
            this.title(model.title);
            this.toolId(model.toolId);
            this.description(model.description);
            this.instruction(model.instruction);
            this.overrideInputValues(model.overrideInputValues);
            this.outputFilters(model.outputFilters);
            this.inputSchema(model.inputSchema);
            this.outputSchema(model.outputSchema);
            this.annotations(model.annotations);
            this.userInteractionConfiguration(model.userInteractionConfiguration);
        }

        public final String getToolName() {
            return this.toolName;
        }

        public final void setToolName(String toolName) {
            this.toolName = toolName;
        }

        @Override
        public final Builder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        public final String getToolType() {
            return this.toolType;
        }

        public final void setToolType(String toolType) {
            this.toolType = toolType;
        }

        @Override
        public final Builder toolType(String toolType) {
            this.toolType = toolType;
            return this;
        }

        @Override
        public final Builder toolType(ToolType toolType) {
            this.toolType(toolType == null ? null : toolType.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getToolId() {
            return this.toolId;
        }

        public final void setToolId(String toolId) {
            this.toolId = toolId;
        }

        @Override
        public final Builder toolId(String toolId) {
            this.toolId = toolId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ToolInstruction.Builder getInstruction() {
            return this.instruction != null ? this.instruction.toBuilder() : null;
        }

        public final void setInstruction(ToolInstruction.BuilderImpl instruction) {
            this.instruction = instruction != null ? instruction.build() : null;
        }

        @Override
        public final Builder instruction(ToolInstruction instruction) {
            this.instruction = instruction;
            return this;
        }

        public final List<ToolOverrideInputValue.Builder> getOverrideInputValues() {
            List<ToolOverrideInputValue.Builder> result = ToolOverrideInputValueListCopier.copyToBuilder(this.overrideInputValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrideInputValues(Collection<ToolOverrideInputValue.BuilderImpl> overrideInputValues) {
            this.overrideInputValues = ToolOverrideInputValueListCopier.copyFromBuilder(overrideInputValues);
        }

        @Override
        public final Builder overrideInputValues(Collection<ToolOverrideInputValue> overrideInputValues) {
            this.overrideInputValues = ToolOverrideInputValueListCopier.copy(overrideInputValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrideInputValues(ToolOverrideInputValue ... overrideInputValues) {
            this.overrideInputValues(Arrays.asList(overrideInputValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrideInputValues(Consumer<ToolOverrideInputValue.Builder> ... overrideInputValues) {
            this.overrideInputValues(Stream.of(overrideInputValues).map(c -> (ToolOverrideInputValue)((ToolOverrideInputValue.Builder)ToolOverrideInputValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ToolOutputFilter.Builder> getOutputFilters() {
            List<ToolOutputFilter.Builder> result = ToolOutputFilterListCopier.copyToBuilder(this.outputFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputFilters(Collection<ToolOutputFilter.BuilderImpl> outputFilters) {
            this.outputFilters = ToolOutputFilterListCopier.copyFromBuilder(outputFilters);
        }

        @Override
        public final Builder outputFilters(Collection<ToolOutputFilter> outputFilters) {
            this.outputFilters = ToolOutputFilterListCopier.copy(outputFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputFilters(ToolOutputFilter ... outputFilters) {
            this.outputFilters(Arrays.asList(outputFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputFilters(Consumer<ToolOutputFilter.Builder> ... outputFilters) {
            this.outputFilters(Stream.of(outputFilters).map(c -> (ToolOutputFilter)((ToolOutputFilter.Builder)ToolOutputFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Document getInputSchema() {
            return this.inputSchema;
        }

        public final void setInputSchema(Document inputSchema) {
            this.inputSchema = inputSchema;
        }

        @Override
        public final Builder inputSchema(Document inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final Document getOutputSchema() {
            return this.outputSchema;
        }

        public final void setOutputSchema(Document outputSchema) {
            this.outputSchema = outputSchema;
        }

        @Override
        public final Builder outputSchema(Document outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        public final Annotation.Builder getAnnotations() {
            return this.annotations != null ? this.annotations.toBuilder() : null;
        }

        public final void setAnnotations(Annotation.BuilderImpl annotations) {
            this.annotations = annotations != null ? annotations.build() : null;
        }

        @Override
        public final Builder annotations(Annotation annotations) {
            this.annotations = annotations;
            return this;
        }

        public final UserInteractionConfiguration.Builder getUserInteractionConfiguration() {
            return this.userInteractionConfiguration != null ? this.userInteractionConfiguration.toBuilder() : null;
        }

        public final void setUserInteractionConfiguration(UserInteractionConfiguration.BuilderImpl userInteractionConfiguration) {
            this.userInteractionConfiguration = userInteractionConfiguration != null ? userInteractionConfiguration.build() : null;
        }

        @Override
        public final Builder userInteractionConfiguration(UserInteractionConfiguration userInteractionConfiguration) {
            this.userInteractionConfiguration = userInteractionConfiguration;
            return this;
        }

        public ToolConfiguration build() {
            return new ToolConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolConfiguration> {
        public Builder toolName(String var1);

        public Builder toolType(String var1);

        public Builder toolType(ToolType var1);

        public Builder title(String var1);

        public Builder toolId(String var1);

        public Builder description(String var1);

        public Builder instruction(ToolInstruction var1);

        default public Builder instruction(Consumer<ToolInstruction.Builder> instruction) {
            return this.instruction((ToolInstruction)((ToolInstruction.Builder)ToolInstruction.builder().applyMutation(instruction)).build());
        }

        public Builder overrideInputValues(Collection<ToolOverrideInputValue> var1);

        public Builder overrideInputValues(ToolOverrideInputValue ... var1);

        public Builder overrideInputValues(Consumer<ToolOverrideInputValue.Builder> ... var1);

        public Builder outputFilters(Collection<ToolOutputFilter> var1);

        public Builder outputFilters(ToolOutputFilter ... var1);

        public Builder outputFilters(Consumer<ToolOutputFilter.Builder> ... var1);

        public Builder inputSchema(Document var1);

        public Builder outputSchema(Document var1);

        public Builder annotations(Annotation var1);

        default public Builder annotations(Consumer<Annotation.Builder> annotations) {
            return this.annotations((Annotation)((Annotation.Builder)Annotation.builder().applyMutation(annotations)).build());
        }

        public Builder userInteractionConfiguration(UserInteractionConfiguration var1);

        default public Builder userInteractionConfiguration(Consumer<UserInteractionConfiguration.Builder> userInteractionConfiguration) {
            return this.userInteractionConfiguration((UserInteractionConfiguration)((UserInteractionConfiguration.Builder)UserInteractionConfiguration.builder().applyMutation(userInteractionConfiguration)).build());
        }
    }
}

