/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailAssessment;
import software.amazon.awssdk.services.qconnect.model.Citation;
import software.amazon.awssdk.services.qconnect.model.CitationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextMessage> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(TextMessage.getter(TextMessage::value)).setter(TextMessage.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<List<Citation>> CITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("citations").getter(TextMessage.getter(TextMessage::citations)).setter(TextMessage.setter(Builder::citations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Citation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AIGuardrailAssessment> AI_GUARDRAIL_ASSESSMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aiGuardrailAssessment").getter(TextMessage.getter(TextMessage::aiGuardrailAssessment)).setter(TextMessage.setter(Builder::aiGuardrailAssessment)).constructor(AIGuardrailAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailAssessment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, CITATIONS_FIELD, AI_GUARDRAIL_ASSESSMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TextMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String value;
    private final List<Citation> citations;
    private final AIGuardrailAssessment aiGuardrailAssessment;

    private TextMessage(BuilderImpl builder) {
        this.value = builder.value;
        this.citations = builder.citations;
        this.aiGuardrailAssessment = builder.aiGuardrailAssessment;
    }

    public final String value() {
        return this.value;
    }

    public final boolean hasCitations() {
        return this.citations != null && !(this.citations instanceof SdkAutoConstructList);
    }

    public final List<Citation> citations() {
        return this.citations;
    }

    public final AIGuardrailAssessment aiGuardrailAssessment() {
        return this.aiGuardrailAssessment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCitations() ? this.citations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aiGuardrailAssessment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextMessage)) {
            return false;
        }
        TextMessage other = (TextMessage)obj;
        return Objects.equals(this.value(), other.value()) && this.hasCitations() == other.hasCitations() && Objects.equals(this.citations(), other.citations()) && Objects.equals(this.aiGuardrailAssessment(), other.aiGuardrailAssessment());
    }

    public final String toString() {
        return ToString.builder((String)"TextMessage").add("Value", (Object)(this.value() == null ? null : "*** Sensitive Data Redacted ***")).add("Citations", this.hasCitations() ? this.citations() : null).add("AiGuardrailAssessment", (Object)this.aiGuardrailAssessment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "citations": {
                return Optional.ofNullable(clazz.cast(this.citations()));
            }
            case "aiGuardrailAssessment": {
                return Optional.ofNullable(clazz.cast(this.aiGuardrailAssessment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", VALUE_FIELD);
        map.put("citations", CITATIONS_FIELD);
        map.put("aiGuardrailAssessment", AI_GUARDRAIL_ASSESSMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextMessage, T> g) {
        return obj -> g.apply((TextMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private List<Citation> citations = DefaultSdkAutoConstructList.getInstance();
        private AIGuardrailAssessment aiGuardrailAssessment;

        private BuilderImpl() {
        }

        private BuilderImpl(TextMessage model) {
            this.value(model.value);
            this.citations(model.citations);
            this.aiGuardrailAssessment(model.aiGuardrailAssessment);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final List<Citation.Builder> getCitations() {
            List<Citation.Builder> result = CitationsCopier.copyToBuilder(this.citations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCitations(Collection<Citation.BuilderImpl> citations) {
            this.citations = CitationsCopier.copyFromBuilder(citations);
        }

        @Override
        public final Builder citations(Collection<Citation> citations) {
            this.citations = CitationsCopier.copy(citations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Citation ... citations) {
            this.citations(Arrays.asList(citations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Consumer<Citation.Builder> ... citations) {
            this.citations(Stream.of(citations).map(c -> (Citation)((Citation.Builder)Citation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AIGuardrailAssessment.Builder getAiGuardrailAssessment() {
            return this.aiGuardrailAssessment != null ? this.aiGuardrailAssessment.toBuilder() : null;
        }

        public final void setAiGuardrailAssessment(AIGuardrailAssessment.BuilderImpl aiGuardrailAssessment) {
            this.aiGuardrailAssessment = aiGuardrailAssessment != null ? aiGuardrailAssessment.build() : null;
        }

        @Override
        public final Builder aiGuardrailAssessment(AIGuardrailAssessment aiGuardrailAssessment) {
            this.aiGuardrailAssessment = aiGuardrailAssessment;
            return this;
        }

        public TextMessage build() {
            return new TextMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextMessage> {
        public Builder value(String var1);

        public Builder citations(Collection<Citation> var1);

        public Builder citations(Citation ... var1);

        public Builder citations(Consumer<Citation.Builder> ... var1);

        public Builder aiGuardrailAssessment(AIGuardrailAssessment var1);

        default public Builder aiGuardrailAssessment(Consumer<AIGuardrailAssessment.Builder> aiGuardrailAssessment) {
            return this.aiGuardrailAssessment((AIGuardrailAssessment)((AIGuardrailAssessment.Builder)AIGuardrailAssessment.builder().applyMutation(aiGuardrailAssessment)).build());
        }
    }
}

