/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.ToolConfiguration;
import software.amazon.awssdk.services.qconnect.model.ToolConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrchestrationAIAgentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrchestrationAIAgentConfiguration> {
    private static final SdkField<String> ORCHESTRATION_AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orchestrationAIPromptId").getter(OrchestrationAIAgentConfiguration.getter(OrchestrationAIAgentConfiguration::orchestrationAIPromptId)).setter(OrchestrationAIAgentConfiguration.setter(Builder::orchestrationAIPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationAIPromptId").build()}).build();
    private static final SdkField<String> ORCHESTRATION_AI_GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orchestrationAIGuardrailId").getter(OrchestrationAIAgentConfiguration.getter(OrchestrationAIAgentConfiguration::orchestrationAIGuardrailId)).setter(OrchestrationAIAgentConfiguration.setter(Builder::orchestrationAIGuardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationAIGuardrailId").build()}).build();
    private static final SdkField<List<ToolConfiguration>> TOOL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("toolConfigurations").getter(OrchestrationAIAgentConfiguration.getter(OrchestrationAIAgentConfiguration::toolConfigurations)).setter(OrchestrationAIAgentConfiguration.setter(Builder::toolConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ToolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECT_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectInstanceArn").getter(OrchestrationAIAgentConfiguration.getter(OrchestrationAIAgentConfiguration::connectInstanceArn)).setter(OrchestrationAIAgentConfiguration.setter(Builder::connectInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceArn").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(OrchestrationAIAgentConfiguration.getter(OrchestrationAIAgentConfiguration::locale)).setter(OrchestrationAIAgentConfiguration.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORCHESTRATION_AI_PROMPT_ID_FIELD, ORCHESTRATION_AI_GUARDRAIL_ID_FIELD, TOOL_CONFIGURATIONS_FIELD, CONNECT_INSTANCE_ARN_FIELD, LOCALE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrchestrationAIAgentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String orchestrationAIPromptId;
    private final String orchestrationAIGuardrailId;
    private final List<ToolConfiguration> toolConfigurations;
    private final String connectInstanceArn;
    private final String locale;

    private OrchestrationAIAgentConfiguration(BuilderImpl builder) {
        this.orchestrationAIPromptId = builder.orchestrationAIPromptId;
        this.orchestrationAIGuardrailId = builder.orchestrationAIGuardrailId;
        this.toolConfigurations = builder.toolConfigurations;
        this.connectInstanceArn = builder.connectInstanceArn;
        this.locale = builder.locale;
    }

    public final String orchestrationAIPromptId() {
        return this.orchestrationAIPromptId;
    }

    public final String orchestrationAIGuardrailId() {
        return this.orchestrationAIGuardrailId;
    }

    public final boolean hasToolConfigurations() {
        return this.toolConfigurations != null && !(this.toolConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ToolConfiguration> toolConfigurations() {
        return this.toolConfigurations;
    }

    public final String connectInstanceArn() {
        return this.connectInstanceArn;
    }

    public final String locale() {
        return this.locale;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrationAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrationAIGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasToolConfigurations() ? this.toolConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrchestrationAIAgentConfiguration)) {
            return false;
        }
        OrchestrationAIAgentConfiguration other = (OrchestrationAIAgentConfiguration)obj;
        return Objects.equals(this.orchestrationAIPromptId(), other.orchestrationAIPromptId()) && Objects.equals(this.orchestrationAIGuardrailId(), other.orchestrationAIGuardrailId()) && this.hasToolConfigurations() == other.hasToolConfigurations() && Objects.equals(this.toolConfigurations(), other.toolConfigurations()) && Objects.equals(this.connectInstanceArn(), other.connectInstanceArn()) && Objects.equals(this.locale(), other.locale());
    }

    public final String toString() {
        return ToString.builder((String)"OrchestrationAIAgentConfiguration").add("OrchestrationAIPromptId", (Object)this.orchestrationAIPromptId()).add("OrchestrationAIGuardrailId", (Object)this.orchestrationAIGuardrailId()).add("ToolConfigurations", this.hasToolConfigurations() ? this.toolConfigurations() : null).add("ConnectInstanceArn", (Object)this.connectInstanceArn()).add("Locale", (Object)this.locale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "orchestrationAIPromptId": {
                return Optional.ofNullable(clazz.cast(this.orchestrationAIPromptId()));
            }
            case "orchestrationAIGuardrailId": {
                return Optional.ofNullable(clazz.cast(this.orchestrationAIGuardrailId()));
            }
            case "toolConfigurations": {
                return Optional.ofNullable(clazz.cast(this.toolConfigurations()));
            }
            case "connectInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.connectInstanceArn()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orchestrationAIPromptId", ORCHESTRATION_AI_PROMPT_ID_FIELD);
        map.put("orchestrationAIGuardrailId", ORCHESTRATION_AI_GUARDRAIL_ID_FIELD);
        map.put("toolConfigurations", TOOL_CONFIGURATIONS_FIELD);
        map.put("connectInstanceArn", CONNECT_INSTANCE_ARN_FIELD);
        map.put("locale", LOCALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrchestrationAIAgentConfiguration, T> g) {
        return obj -> g.apply((OrchestrationAIAgentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String orchestrationAIPromptId;
        private String orchestrationAIGuardrailId;
        private List<ToolConfiguration> toolConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String connectInstanceArn;
        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(OrchestrationAIAgentConfiguration model) {
            this.orchestrationAIPromptId(model.orchestrationAIPromptId);
            this.orchestrationAIGuardrailId(model.orchestrationAIGuardrailId);
            this.toolConfigurations(model.toolConfigurations);
            this.connectInstanceArn(model.connectInstanceArn);
            this.locale(model.locale);
        }

        public final String getOrchestrationAIPromptId() {
            return this.orchestrationAIPromptId;
        }

        public final void setOrchestrationAIPromptId(String orchestrationAIPromptId) {
            this.orchestrationAIPromptId = orchestrationAIPromptId;
        }

        @Override
        public final Builder orchestrationAIPromptId(String orchestrationAIPromptId) {
            this.orchestrationAIPromptId = orchestrationAIPromptId;
            return this;
        }

        public final String getOrchestrationAIGuardrailId() {
            return this.orchestrationAIGuardrailId;
        }

        public final void setOrchestrationAIGuardrailId(String orchestrationAIGuardrailId) {
            this.orchestrationAIGuardrailId = orchestrationAIGuardrailId;
        }

        @Override
        public final Builder orchestrationAIGuardrailId(String orchestrationAIGuardrailId) {
            this.orchestrationAIGuardrailId = orchestrationAIGuardrailId;
            return this;
        }

        public final List<ToolConfiguration.Builder> getToolConfigurations() {
            List<ToolConfiguration.Builder> result = ToolConfigurationListCopier.copyToBuilder(this.toolConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToolConfigurations(Collection<ToolConfiguration.BuilderImpl> toolConfigurations) {
            this.toolConfigurations = ToolConfigurationListCopier.copyFromBuilder(toolConfigurations);
        }

        @Override
        public final Builder toolConfigurations(Collection<ToolConfiguration> toolConfigurations) {
            this.toolConfigurations = ToolConfigurationListCopier.copy(toolConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolConfigurations(ToolConfiguration ... toolConfigurations) {
            this.toolConfigurations(Arrays.asList(toolConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolConfigurations(Consumer<ToolConfiguration.Builder> ... toolConfigurations) {
            this.toolConfigurations(Stream.of(toolConfigurations).map(c -> (ToolConfiguration)((ToolConfiguration.Builder)ToolConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConnectInstanceArn() {
            return this.connectInstanceArn;
        }

        public final void setConnectInstanceArn(String connectInstanceArn) {
            this.connectInstanceArn = connectInstanceArn;
        }

        @Override
        public final Builder connectInstanceArn(String connectInstanceArn) {
            this.connectInstanceArn = connectInstanceArn;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public OrchestrationAIAgentConfiguration build() {
            return new OrchestrationAIAgentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrchestrationAIAgentConfiguration> {
        public Builder orchestrationAIPromptId(String var1);

        public Builder orchestrationAIGuardrailId(String var1);

        public Builder toolConfigurations(Collection<ToolConfiguration> var1);

        public Builder toolConfigurations(ToolConfiguration ... var1);

        public Builder toolConfigurations(Consumer<ToolConfiguration.Builder> ... var1);

        public Builder connectInstanceArn(String var1);

        public Builder locale(String var1);
    }
}

