/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.QuickResponseSearchResultData;
import software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesRequest;
import software.amazon.awssdk.services.qconnect.model.SearchQuickResponsesResponse;

public class SearchQuickResponsesIterable
implements SdkIterable<SearchQuickResponsesResponse> {
    private final QConnectClient client;
    private final SearchQuickResponsesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchQuickResponsesIterable(QConnectClient client, SearchQuickResponsesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchQuickResponsesResponseFetcher();
    }

    public Iterator<SearchQuickResponsesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QuickResponseSearchResultData> results() {
        Function<SearchQuickResponsesResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchQuickResponsesResponseFetcher
    implements SyncPageFetcher<SearchQuickResponsesResponse> {
        private SearchQuickResponsesResponseFetcher() {
        }

        public boolean hasNextPage(SearchQuickResponsesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchQuickResponsesResponse nextPage(SearchQuickResponsesResponse previousPage) {
            if (previousPage == null) {
                return SearchQuickResponsesIterable.this.client.searchQuickResponses(SearchQuickResponsesIterable.this.firstRequest);
            }
            return SearchQuickResponsesIterable.this.client.searchQuickResponses((SearchQuickResponsesRequest)((Object)SearchQuickResponsesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

