/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplatesRequest;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplatesResponse;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateSummary;

public class ListMessageTemplatesIterable
implements SdkIterable<ListMessageTemplatesResponse> {
    private final QConnectClient client;
    private final ListMessageTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMessageTemplatesIterable(QConnectClient client, ListMessageTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMessageTemplatesResponseFetcher();
    }

    public Iterator<ListMessageTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MessageTemplateSummary> messageTemplateSummaries() {
        Function<ListMessageTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.messageTemplateSummaries() != null) {
                return response.messageTemplateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMessageTemplatesResponseFetcher
    implements SyncPageFetcher<ListMessageTemplatesResponse> {
        private ListMessageTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListMessageTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMessageTemplatesResponse nextPage(ListMessageTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListMessageTemplatesIterable.this.client.listMessageTemplates(ListMessageTemplatesIterable.this.firstRequest);
            }
            return ListMessageTemplatesIterable.this.client.listMessageTemplates((ListMessageTemplatesRequest)((Object)ListMessageTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

