/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplateVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplateVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateVersionSummary;

public class ListMessageTemplateVersionsPublisher
implements SdkPublisher<ListMessageTemplateVersionsResponse> {
    private final QConnectAsyncClient client;
    private final ListMessageTemplateVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMessageTemplateVersionsPublisher(QConnectAsyncClient client, ListMessageTemplateVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMessageTemplateVersionsPublisher(QConnectAsyncClient client, ListMessageTemplateVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMessageTemplateVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMessageTemplateVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MessageTemplateVersionSummary> messageTemplateVersionSummaries() {
        Function<ListMessageTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.messageTemplateVersionSummaries() != null) {
                return response.messageTemplateVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMessageTemplateVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMessageTemplateVersionsResponseFetcher
    implements AsyncPageFetcher<ListMessageTemplateVersionsResponse> {
        private ListMessageTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListMessageTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMessageTemplateVersionsResponse> nextPage(ListMessageTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListMessageTemplateVersionsPublisher.this.client.listMessageTemplateVersions(ListMessageTemplateVersionsPublisher.this.firstRequest);
            }
            return ListMessageTemplateVersionsPublisher.this.client.listMessageTemplateVersions((ListMessageTemplateVersionsRequest)((Object)ListMessageTemplateVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

