/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AssistantSummary;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse;

public class ListAssistantsPublisher
implements SdkPublisher<ListAssistantsResponse> {
    private final QConnectAsyncClient client;
    private final ListAssistantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssistantsPublisher(QConnectAsyncClient client, ListAssistantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssistantsPublisher(QConnectAsyncClient client, ListAssistantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssistantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssistantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssistantSummary> assistantSummaries() {
        Function<ListAssistantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assistantSummaries() != null) {
                return response.assistantSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssistantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssistantsResponseFetcher
    implements AsyncPageFetcher<ListAssistantsResponse> {
        private ListAssistantsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssistantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssistantsResponse> nextPage(ListAssistantsResponse previousPage) {
            if (previousPage == null) {
                return ListAssistantsPublisher.this.client.listAssistants(ListAssistantsPublisher.this.firstRequest);
            }
            return ListAssistantsPublisher.this.client.listAssistants((ListAssistantsRequest)((Object)ListAssistantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

