/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Origin {
    SYSTEM("SYSTEM"),
    CUSTOMER("CUSTOMER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Origin> VALUE_MAP;
    private final String value;

    private Origin(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Origin fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Origin> knownValues() {
        EnumSet<Origin> knownValues = EnumSet.allOf(Origin.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Origin.class, Origin::toString);
    }
}

