/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateFilterField;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateFilterFieldListCopier;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateOrderField;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateQueryField;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateQueryFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageTemplateSearchExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageTemplateSearchExpression> {
    private static final SdkField<List<MessageTemplateQueryField>> QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queries").getter(MessageTemplateSearchExpression.getter(MessageTemplateSearchExpression::queries)).setter(MessageTemplateSearchExpression.setter(Builder::queries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTemplateQueryField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MessageTemplateFilterField>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(MessageTemplateSearchExpression.getter(MessageTemplateSearchExpression::filters)).setter(MessageTemplateSearchExpression.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTemplateFilterField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MessageTemplateOrderField> ORDER_ON_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orderOnField").getter(MessageTemplateSearchExpression.getter(MessageTemplateSearchExpression::orderOnField)).setter(MessageTemplateSearchExpression.setter(Builder::orderOnField)).constructor(MessageTemplateOrderField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderOnField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERIES_FIELD, FILTERS_FIELD, ORDER_ON_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageTemplateSearchExpression.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MessageTemplateQueryField> queries;
    private final List<MessageTemplateFilterField> filters;
    private final MessageTemplateOrderField orderOnField;

    private MessageTemplateSearchExpression(BuilderImpl builder) {
        this.queries = builder.queries;
        this.filters = builder.filters;
        this.orderOnField = builder.orderOnField;
    }

    public final boolean hasQueries() {
        return this.queries != null && !(this.queries instanceof SdkAutoConstructList);
    }

    public final List<MessageTemplateQueryField> queries() {
        return this.queries;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<MessageTemplateFilterField> filters() {
        return this.filters;
    }

    public final MessageTemplateOrderField orderOnField() {
        return this.orderOnField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueries() ? this.queries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.orderOnField());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateSearchExpression)) {
            return false;
        }
        MessageTemplateSearchExpression other = (MessageTemplateSearchExpression)obj;
        return this.hasQueries() == other.hasQueries() && Objects.equals(this.queries(), other.queries()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.orderOnField(), other.orderOnField());
    }

    public final String toString() {
        return ToString.builder((String)"MessageTemplateSearchExpression").add("Queries", this.hasQueries() ? this.queries() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("OrderOnField", (Object)this.orderOnField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queries": {
                return Optional.ofNullable(clazz.cast(this.queries()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "orderOnField": {
                return Optional.ofNullable(clazz.cast(this.orderOnField()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queries", QUERIES_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("orderOnField", ORDER_ON_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateSearchExpression, T> g) {
        return obj -> g.apply((MessageTemplateSearchExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MessageTemplateQueryField> queries = DefaultSdkAutoConstructList.getInstance();
        private List<MessageTemplateFilterField> filters = DefaultSdkAutoConstructList.getInstance();
        private MessageTemplateOrderField orderOnField;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateSearchExpression model) {
            this.queries(model.queries);
            this.filters(model.filters);
            this.orderOnField(model.orderOnField);
        }

        public final List<MessageTemplateQueryField.Builder> getQueries() {
            List<MessageTemplateQueryField.Builder> result = MessageTemplateQueryFieldListCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<MessageTemplateQueryField.BuilderImpl> queries) {
            this.queries = MessageTemplateQueryFieldListCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<MessageTemplateQueryField> queries) {
            this.queries = MessageTemplateQueryFieldListCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(MessageTemplateQueryField ... queries) {
            this.queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<MessageTemplateQueryField.Builder> ... queries) {
            this.queries(Stream.of(queries).map(c -> (MessageTemplateQueryField)((MessageTemplateQueryField.Builder)MessageTemplateQueryField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MessageTemplateFilterField.Builder> getFilters() {
            List<MessageTemplateFilterField.Builder> result = MessageTemplateFilterFieldListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<MessageTemplateFilterField.BuilderImpl> filters) {
            this.filters = MessageTemplateFilterFieldListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<MessageTemplateFilterField> filters) {
            this.filters = MessageTemplateFilterFieldListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(MessageTemplateFilterField ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<MessageTemplateFilterField.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (MessageTemplateFilterField)((MessageTemplateFilterField.Builder)MessageTemplateFilterField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MessageTemplateOrderField.Builder getOrderOnField() {
            return this.orderOnField != null ? this.orderOnField.toBuilder() : null;
        }

        public final void setOrderOnField(MessageTemplateOrderField.BuilderImpl orderOnField) {
            this.orderOnField = orderOnField != null ? orderOnField.build() : null;
        }

        @Override
        public final Builder orderOnField(MessageTemplateOrderField orderOnField) {
            this.orderOnField = orderOnField;
            return this;
        }

        public MessageTemplateSearchExpression build() {
            return new MessageTemplateSearchExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageTemplateSearchExpression> {
        public Builder queries(Collection<MessageTemplateQueryField> var1);

        public Builder queries(MessageTemplateQueryField ... var1);

        public Builder queries(Consumer<MessageTemplateQueryField.Builder> ... var1);

        public Builder filters(Collection<MessageTemplateFilterField> var1);

        public Builder filters(MessageTemplateFilterField ... var1);

        public Builder filters(Consumer<MessageTemplateFilterField.Builder> ... var1);

        public Builder orderOnField(MessageTemplateOrderField var1);

        default public Builder orderOnField(Consumer<MessageTemplateOrderField.Builder> orderOnField) {
            return this.orderOnField((MessageTemplateOrderField)((MessageTemplateOrderField.Builder)MessageTemplateOrderField.builder().applyMutation(orderOnField)).build());
        }
    }
}

