/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.DataSummary;
import software.amazon.awssdk.services.qconnect.model.DataSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerativeChunkDataDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GenerativeChunkDataDetails> {
    private static final SdkField<String> COMPLETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("completion").getter(GenerativeChunkDataDetails.getter(GenerativeChunkDataDetails::completion)).setter(GenerativeChunkDataDetails.setter(Builder::completion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completion").build()}).build();
    private static final SdkField<List<DataSummary>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("references").getter(GenerativeChunkDataDetails.getter(GenerativeChunkDataDetails::references)).setter(GenerativeChunkDataDetails.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("references").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_CHUNK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextChunkToken").getter(GenerativeChunkDataDetails.getter(GenerativeChunkDataDetails::nextChunkToken)).setter(GenerativeChunkDataDetails.setter(Builder::nextChunkToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextChunkToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_FIELD, REFERENCES_FIELD, NEXT_CHUNK_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerativeChunkDataDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String completion;
    private final List<DataSummary> references;
    private final String nextChunkToken;

    private GenerativeChunkDataDetails(BuilderImpl builder) {
        this.completion = builder.completion;
        this.references = builder.references;
        this.nextChunkToken = builder.nextChunkToken;
    }

    public final String completion() {
        return this.completion;
    }

    public final boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructList);
    }

    public final List<DataSummary> references() {
        return this.references;
    }

    public final String nextChunkToken() {
        return this.nextChunkToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextChunkToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerativeChunkDataDetails)) {
            return false;
        }
        GenerativeChunkDataDetails other = (GenerativeChunkDataDetails)obj;
        return Objects.equals(this.completion(), other.completion()) && this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references()) && Objects.equals(this.nextChunkToken(), other.nextChunkToken());
    }

    public final String toString() {
        return ToString.builder((String)"GenerativeChunkDataDetails").add("Completion", (Object)(this.completion() == null ? null : "*** Sensitive Data Redacted ***")).add("References", this.hasReferences() ? this.references() : null).add("NextChunkToken", (Object)this.nextChunkToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completion": {
                return Optional.ofNullable(clazz.cast(this.completion()));
            }
            case "references": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
            case "nextChunkToken": {
                return Optional.ofNullable(clazz.cast(this.nextChunkToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("completion", COMPLETION_FIELD);
        map.put("references", REFERENCES_FIELD);
        map.put("nextChunkToken", NEXT_CHUNK_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerativeChunkDataDetails, T> g) {
        return obj -> g.apply((GenerativeChunkDataDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String completion;
        private List<DataSummary> references = DefaultSdkAutoConstructList.getInstance();
        private String nextChunkToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerativeChunkDataDetails model) {
            this.completion(model.completion);
            this.references(model.references);
            this.nextChunkToken(model.nextChunkToken);
        }

        public final String getCompletion() {
            return this.completion;
        }

        public final void setCompletion(String completion) {
            this.completion = completion;
        }

        @Override
        public final Builder completion(String completion) {
            this.completion = completion;
            return this;
        }

        public final List<DataSummary.Builder> getReferences() {
            List<DataSummary.Builder> result = DataSummaryListCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferences(Collection<DataSummary.BuilderImpl> references) {
            this.references = DataSummaryListCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Collection<DataSummary> references) {
            this.references = DataSummaryListCopier.copy(references);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(DataSummary ... references) {
            this.references(Arrays.asList(references));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(Consumer<DataSummary.Builder> ... references) {
            this.references(Stream.of(references).map(c -> (DataSummary)((DataSummary.Builder)DataSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextChunkToken() {
            return this.nextChunkToken;
        }

        public final void setNextChunkToken(String nextChunkToken) {
            this.nextChunkToken = nextChunkToken;
        }

        @Override
        public final Builder nextChunkToken(String nextChunkToken) {
            this.nextChunkToken = nextChunkToken;
            return this;
        }

        public GenerativeChunkDataDetails build() {
            return new GenerativeChunkDataDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GenerativeChunkDataDetails> {
        public Builder completion(String var1);

        public Builder references(Collection<DataSummary> var1);

        public Builder references(DataSummary ... var1);

        public Builder references(Consumer<DataSummary.Builder> ... var1);

        public Builder nextChunkToken(String var1);
    }
}

