/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.ContentAssociationSummary;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListContentAssociationsResponse;

public class ListContentAssociationsPublisher
implements SdkPublisher<ListContentAssociationsResponse> {
    private final QConnectAsyncClient client;
    private final ListContentAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContentAssociationsPublisher(QConnectAsyncClient client, ListContentAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContentAssociationsPublisher(QConnectAsyncClient client, ListContentAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContentAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContentAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContentAssociationSummary> contentAssociationSummaries() {
        Function<ListContentAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contentAssociationSummaries() != null) {
                return response.contentAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContentAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContentAssociationsResponseFetcher
    implements AsyncPageFetcher<ListContentAssociationsResponse> {
        private ListContentAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListContentAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContentAssociationsResponse> nextPage(ListContentAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListContentAssociationsPublisher.this.client.listContentAssociations(ListContentAssociationsPublisher.this.firstRequest);
            }
            return ListContentAssociationsPublisher.this.client.listContentAssociations((ListContentAssociationsRequest)((Object)ListContentAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

