/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplatesRequest;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplatesResponse;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateSummary;

public class ListMessageTemplatesPublisher
implements SdkPublisher<ListMessageTemplatesResponse> {
    private final QConnectAsyncClient client;
    private final ListMessageTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMessageTemplatesPublisher(QConnectAsyncClient client, ListMessageTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMessageTemplatesPublisher(QConnectAsyncClient client, ListMessageTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMessageTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMessageTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MessageTemplateSummary> messageTemplateSummaries() {
        Function<ListMessageTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.messageTemplateSummaries() != null) {
                return response.messageTemplateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMessageTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMessageTemplatesResponseFetcher
    implements AsyncPageFetcher<ListMessageTemplatesResponse> {
        private ListMessageTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListMessageTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMessageTemplatesResponse> nextPage(ListMessageTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListMessageTemplatesPublisher.this.client.listMessageTemplates(ListMessageTemplatesPublisher.this.firstRequest);
            }
            return ListMessageTemplatesPublisher.this.client.listMessageTemplates((ListMessageTemplatesRequest)((Object)ListMessageTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

