/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIPromptSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptsResponse;

public class ListAIPromptsPublisher
implements SdkPublisher<ListAiPromptsResponse> {
    private final QConnectAsyncClient client;
    private final ListAiPromptsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAIPromptsPublisher(QConnectAsyncClient client, ListAiPromptsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAIPromptsPublisher(QConnectAsyncClient client, ListAiPromptsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAiPromptsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAiPromptsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AIPromptSummary> aiPromptSummaries() {
        Function<ListAiPromptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiPromptSummaries() != null) {
                return response.aiPromptSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAiPromptsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAiPromptsResponseFetcher
    implements AsyncPageFetcher<ListAiPromptsResponse> {
        private ListAiPromptsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiPromptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAiPromptsResponse> nextPage(ListAiPromptsResponse previousPage) {
            if (previousPage == null) {
                return ListAIPromptsPublisher.this.client.listAIPrompts(ListAIPromptsPublisher.this.firstRequest);
            }
            return ListAIPromptsPublisher.this.client.listAIPrompts((ListAiPromptsRequest)((Object)ListAIPromptsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

