/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.AssociationConfiguration;
import software.amazon.awssdk.services.qconnect.model.AssociationConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelfServiceAIAgentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelfServiceAIAgentConfiguration> {
    private static final SdkField<List<AssociationConfiguration>> ASSOCIATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associationConfigurations").getter(SelfServiceAIAgentConfiguration.getter(SelfServiceAIAgentConfiguration::associationConfigurations)).setter(SelfServiceAIAgentConfiguration.setter(Builder::associationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SELF_SERVICE_AI_GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("selfServiceAIGuardrailId").getter(SelfServiceAIAgentConfiguration.getter(SelfServiceAIAgentConfiguration::selfServiceAIGuardrailId)).setter(SelfServiceAIAgentConfiguration.setter(Builder::selfServiceAIGuardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfServiceAIGuardrailId").build()}).build();
    private static final SdkField<String> SELF_SERVICE_ANSWER_GENERATION_AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("selfServiceAnswerGenerationAIPromptId").getter(SelfServiceAIAgentConfiguration.getter(SelfServiceAIAgentConfiguration::selfServiceAnswerGenerationAIPromptId)).setter(SelfServiceAIAgentConfiguration.setter(Builder::selfServiceAnswerGenerationAIPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfServiceAnswerGenerationAIPromptId").build()}).build();
    private static final SdkField<String> SELF_SERVICE_PRE_PROCESSING_AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("selfServicePreProcessingAIPromptId").getter(SelfServiceAIAgentConfiguration.getter(SelfServiceAIAgentConfiguration::selfServicePreProcessingAIPromptId)).setter(SelfServiceAIAgentConfiguration.setter(Builder::selfServicePreProcessingAIPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfServicePreProcessingAIPromptId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_CONFIGURATIONS_FIELD, SELF_SERVICE_AI_GUARDRAIL_ID_FIELD, SELF_SERVICE_ANSWER_GENERATION_AI_PROMPT_ID_FIELD, SELF_SERVICE_PRE_PROCESSING_AI_PROMPT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SelfServiceAIAgentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AssociationConfiguration> associationConfigurations;
    private final String selfServiceAIGuardrailId;
    private final String selfServiceAnswerGenerationAIPromptId;
    private final String selfServicePreProcessingAIPromptId;

    private SelfServiceAIAgentConfiguration(BuilderImpl builder) {
        this.associationConfigurations = builder.associationConfigurations;
        this.selfServiceAIGuardrailId = builder.selfServiceAIGuardrailId;
        this.selfServiceAnswerGenerationAIPromptId = builder.selfServiceAnswerGenerationAIPromptId;
        this.selfServicePreProcessingAIPromptId = builder.selfServicePreProcessingAIPromptId;
    }

    public final boolean hasAssociationConfigurations() {
        return this.associationConfigurations != null && !(this.associationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AssociationConfiguration> associationConfigurations() {
        return this.associationConfigurations;
    }

    public final String selfServiceAIGuardrailId() {
        return this.selfServiceAIGuardrailId;
    }

    public final String selfServiceAnswerGenerationAIPromptId() {
        return this.selfServiceAnswerGenerationAIPromptId;
    }

    public final String selfServicePreProcessingAIPromptId() {
        return this.selfServicePreProcessingAIPromptId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationConfigurations() ? this.associationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selfServiceAIGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfServiceAnswerGenerationAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfServicePreProcessingAIPromptId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfServiceAIAgentConfiguration)) {
            return false;
        }
        SelfServiceAIAgentConfiguration other = (SelfServiceAIAgentConfiguration)obj;
        return this.hasAssociationConfigurations() == other.hasAssociationConfigurations() && Objects.equals(this.associationConfigurations(), other.associationConfigurations()) && Objects.equals(this.selfServiceAIGuardrailId(), other.selfServiceAIGuardrailId()) && Objects.equals(this.selfServiceAnswerGenerationAIPromptId(), other.selfServiceAnswerGenerationAIPromptId()) && Objects.equals(this.selfServicePreProcessingAIPromptId(), other.selfServicePreProcessingAIPromptId());
    }

    public final String toString() {
        return ToString.builder((String)"SelfServiceAIAgentConfiguration").add("AssociationConfigurations", this.hasAssociationConfigurations() ? this.associationConfigurations() : null).add("SelfServiceAIGuardrailId", (Object)this.selfServiceAIGuardrailId()).add("SelfServiceAnswerGenerationAIPromptId", (Object)this.selfServiceAnswerGenerationAIPromptId()).add("SelfServicePreProcessingAIPromptId", (Object)this.selfServicePreProcessingAIPromptId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.associationConfigurations()));
            }
            case "selfServiceAIGuardrailId": {
                return Optional.ofNullable(clazz.cast(this.selfServiceAIGuardrailId()));
            }
            case "selfServiceAnswerGenerationAIPromptId": {
                return Optional.ofNullable(clazz.cast(this.selfServiceAnswerGenerationAIPromptId()));
            }
            case "selfServicePreProcessingAIPromptId": {
                return Optional.ofNullable(clazz.cast(this.selfServicePreProcessingAIPromptId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("associationConfigurations", ASSOCIATION_CONFIGURATIONS_FIELD);
        map.put("selfServiceAIGuardrailId", SELF_SERVICE_AI_GUARDRAIL_ID_FIELD);
        map.put("selfServiceAnswerGenerationAIPromptId", SELF_SERVICE_ANSWER_GENERATION_AI_PROMPT_ID_FIELD);
        map.put("selfServicePreProcessingAIPromptId", SELF_SERVICE_PRE_PROCESSING_AI_PROMPT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelfServiceAIAgentConfiguration, T> g) {
        return obj -> g.apply((SelfServiceAIAgentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AssociationConfiguration> associationConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String selfServiceAIGuardrailId;
        private String selfServiceAnswerGenerationAIPromptId;
        private String selfServicePreProcessingAIPromptId;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfServiceAIAgentConfiguration model) {
            this.associationConfigurations(model.associationConfigurations);
            this.selfServiceAIGuardrailId(model.selfServiceAIGuardrailId);
            this.selfServiceAnswerGenerationAIPromptId(model.selfServiceAnswerGenerationAIPromptId);
            this.selfServicePreProcessingAIPromptId(model.selfServicePreProcessingAIPromptId);
        }

        public final List<AssociationConfiguration.Builder> getAssociationConfigurations() {
            List<AssociationConfiguration.Builder> result = AssociationConfigurationListCopier.copyToBuilder(this.associationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociationConfigurations(Collection<AssociationConfiguration.BuilderImpl> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copyFromBuilder(associationConfigurations);
        }

        @Override
        public final Builder associationConfigurations(Collection<AssociationConfiguration> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copy(associationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(AssociationConfiguration ... associationConfigurations) {
            this.associationConfigurations(Arrays.asList(associationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(Consumer<AssociationConfiguration.Builder> ... associationConfigurations) {
            this.associationConfigurations(Stream.of(associationConfigurations).map(c -> (AssociationConfiguration)((AssociationConfiguration.Builder)AssociationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSelfServiceAIGuardrailId() {
            return this.selfServiceAIGuardrailId;
        }

        public final void setSelfServiceAIGuardrailId(String selfServiceAIGuardrailId) {
            this.selfServiceAIGuardrailId = selfServiceAIGuardrailId;
        }

        @Override
        public final Builder selfServiceAIGuardrailId(String selfServiceAIGuardrailId) {
            this.selfServiceAIGuardrailId = selfServiceAIGuardrailId;
            return this;
        }

        public final String getSelfServiceAnswerGenerationAIPromptId() {
            return this.selfServiceAnswerGenerationAIPromptId;
        }

        public final void setSelfServiceAnswerGenerationAIPromptId(String selfServiceAnswerGenerationAIPromptId) {
            this.selfServiceAnswerGenerationAIPromptId = selfServiceAnswerGenerationAIPromptId;
        }

        @Override
        public final Builder selfServiceAnswerGenerationAIPromptId(String selfServiceAnswerGenerationAIPromptId) {
            this.selfServiceAnswerGenerationAIPromptId = selfServiceAnswerGenerationAIPromptId;
            return this;
        }

        public final String getSelfServicePreProcessingAIPromptId() {
            return this.selfServicePreProcessingAIPromptId;
        }

        public final void setSelfServicePreProcessingAIPromptId(String selfServicePreProcessingAIPromptId) {
            this.selfServicePreProcessingAIPromptId = selfServicePreProcessingAIPromptId;
        }

        @Override
        public final Builder selfServicePreProcessingAIPromptId(String selfServicePreProcessingAIPromptId) {
            this.selfServicePreProcessingAIPromptId = selfServicePreProcessingAIPromptId;
            return this;
        }

        public SelfServiceAIAgentConfiguration build() {
            return new SelfServiceAIAgentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelfServiceAIAgentConfiguration> {
        public Builder associationConfigurations(Collection<AssociationConfiguration> var1);

        public Builder associationConfigurations(AssociationConfiguration ... var1);

        public Builder associationConfigurations(Consumer<AssociationConfiguration.Builder> ... var1);

        public Builder selfServiceAIGuardrailId(String var1);

        public Builder selfServiceAnswerGenerationAIPromptId(String var1);

        public Builder selfServicePreProcessingAIPromptId(String var1);
    }
}

