/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.ConversationState;
import software.amazon.awssdk.services.qconnect.model.MessageOutput;
import software.amazon.awssdk.services.qconnect.model.MessageType;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.services.qconnect.model.RuntimeSessionData;
import software.amazon.awssdk.services.qconnect.model.RuntimeSessionDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNextMessageResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, GetNextMessageResponse> {
    private static final SdkField<List<RuntimeSessionData>> CONVERSATION_SESSION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conversationSessionData").getter(GetNextMessageResponse.getter(GetNextMessageResponse::conversationSessionData)).setter(GetNextMessageResponse.setter(Builder::conversationSessionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationSessionData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuntimeSessionData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConversationState> CONVERSATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conversationState").getter(GetNextMessageResponse.getter(GetNextMessageResponse::conversationState)).setter(GetNextMessageResponse.setter(Builder::conversationState)).constructor(ConversationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationState").build()}).build();
    private static final SdkField<String> NEXT_MESSAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextMessageToken").getter(GetNextMessageResponse.getter(GetNextMessageResponse::nextMessageToken)).setter(GetNextMessageResponse.setter(Builder::nextMessageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMessageToken").build()}).build();
    private static final SdkField<String> REQUEST_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestMessageId").getter(GetNextMessageResponse.getter(GetNextMessageResponse::requestMessageId)).setter(GetNextMessageResponse.setter(Builder::requestMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMessageId").build()}).build();
    private static final SdkField<MessageOutput> RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("response").getter(GetNextMessageResponse.getter(GetNextMessageResponse::response)).setter(GetNextMessageResponse.setter(Builder::response)).constructor(MessageOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("response").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetNextMessageResponse.getter(GetNextMessageResponse::typeAsString)).setter(GetNextMessageResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_SESSION_DATA_FIELD, CONVERSATION_STATE_FIELD, NEXT_MESSAGE_TOKEN_FIELD, REQUEST_MESSAGE_ID_FIELD, RESPONSE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetNextMessageResponse.memberNameToFieldInitializer();
    private final List<RuntimeSessionData> conversationSessionData;
    private final ConversationState conversationState;
    private final String nextMessageToken;
    private final String requestMessageId;
    private final MessageOutput response;
    private final String type;

    private GetNextMessageResponse(BuilderImpl builder) {
        super(builder);
        this.conversationSessionData = builder.conversationSessionData;
        this.conversationState = builder.conversationState;
        this.nextMessageToken = builder.nextMessageToken;
        this.requestMessageId = builder.requestMessageId;
        this.response = builder.response;
        this.type = builder.type;
    }

    public final boolean hasConversationSessionData() {
        return this.conversationSessionData != null && !(this.conversationSessionData instanceof SdkAutoConstructList);
    }

    public final List<RuntimeSessionData> conversationSessionData() {
        return this.conversationSessionData;
    }

    public final ConversationState conversationState() {
        return this.conversationState;
    }

    public final String nextMessageToken() {
        return this.nextMessageToken;
    }

    public final String requestMessageId() {
        return this.requestMessageId;
    }

    public final MessageOutput response() {
        return this.response;
    }

    public final MessageType type() {
        return MessageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConversationSessionData() ? this.conversationSessionData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMessageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.response());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNextMessageResponse)) {
            return false;
        }
        GetNextMessageResponse other = (GetNextMessageResponse)((Object)obj);
        return this.hasConversationSessionData() == other.hasConversationSessionData() && Objects.equals(this.conversationSessionData(), other.conversationSessionData()) && Objects.equals(this.conversationState(), other.conversationState()) && Objects.equals(this.nextMessageToken(), other.nextMessageToken()) && Objects.equals(this.requestMessageId(), other.requestMessageId()) && Objects.equals(this.response(), other.response()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetNextMessageResponse").add("ConversationSessionData", this.hasConversationSessionData() ? this.conversationSessionData() : null).add("ConversationState", (Object)this.conversationState()).add("NextMessageToken", (Object)this.nextMessageToken()).add("RequestMessageId", (Object)this.requestMessageId()).add("Response", (Object)this.response()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversationSessionData": {
                return Optional.ofNullable(clazz.cast(this.conversationSessionData()));
            }
            case "conversationState": {
                return Optional.ofNullable(clazz.cast(this.conversationState()));
            }
            case "nextMessageToken": {
                return Optional.ofNullable(clazz.cast(this.nextMessageToken()));
            }
            case "requestMessageId": {
                return Optional.ofNullable(clazz.cast(this.requestMessageId()));
            }
            case "response": {
                return Optional.ofNullable(clazz.cast(this.response()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conversationSessionData", CONVERSATION_SESSION_DATA_FIELD);
        map.put("conversationState", CONVERSATION_STATE_FIELD);
        map.put("nextMessageToken", NEXT_MESSAGE_TOKEN_FIELD);
        map.put("requestMessageId", REQUEST_MESSAGE_ID_FIELD);
        map.put("response", RESPONSE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNextMessageResponse, T> g) {
        return obj -> g.apply((GetNextMessageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<RuntimeSessionData> conversationSessionData = DefaultSdkAutoConstructList.getInstance();
        private ConversationState conversationState;
        private String nextMessageToken;
        private String requestMessageId;
        private MessageOutput response;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNextMessageResponse model) {
            super(model);
            this.conversationSessionData(model.conversationSessionData);
            this.conversationState(model.conversationState);
            this.nextMessageToken(model.nextMessageToken);
            this.requestMessageId(model.requestMessageId);
            this.response(model.response);
            this.type(model.type);
        }

        public final List<RuntimeSessionData.Builder> getConversationSessionData() {
            List<RuntimeSessionData.Builder> result = RuntimeSessionDataListCopier.copyToBuilder(this.conversationSessionData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConversationSessionData(Collection<RuntimeSessionData.BuilderImpl> conversationSessionData) {
            this.conversationSessionData = RuntimeSessionDataListCopier.copyFromBuilder(conversationSessionData);
        }

        @Override
        public final Builder conversationSessionData(Collection<RuntimeSessionData> conversationSessionData) {
            this.conversationSessionData = RuntimeSessionDataListCopier.copy(conversationSessionData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversationSessionData(RuntimeSessionData ... conversationSessionData) {
            this.conversationSessionData(Arrays.asList(conversationSessionData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversationSessionData(Consumer<RuntimeSessionData.Builder> ... conversationSessionData) {
            this.conversationSessionData(Stream.of(conversationSessionData).map(c -> (RuntimeSessionData)((RuntimeSessionData.Builder)RuntimeSessionData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConversationState.Builder getConversationState() {
            return this.conversationState != null ? this.conversationState.toBuilder() : null;
        }

        public final void setConversationState(ConversationState.BuilderImpl conversationState) {
            this.conversationState = conversationState != null ? conversationState.build() : null;
        }

        @Override
        public final Builder conversationState(ConversationState conversationState) {
            this.conversationState = conversationState;
            return this;
        }

        public final String getNextMessageToken() {
            return this.nextMessageToken;
        }

        public final void setNextMessageToken(String nextMessageToken) {
            this.nextMessageToken = nextMessageToken;
        }

        @Override
        public final Builder nextMessageToken(String nextMessageToken) {
            this.nextMessageToken = nextMessageToken;
            return this;
        }

        public final String getRequestMessageId() {
            return this.requestMessageId;
        }

        public final void setRequestMessageId(String requestMessageId) {
            this.requestMessageId = requestMessageId;
        }

        @Override
        public final Builder requestMessageId(String requestMessageId) {
            this.requestMessageId = requestMessageId;
            return this;
        }

        public final MessageOutput.Builder getResponse() {
            return this.response != null ? this.response.toBuilder() : null;
        }

        public final void setResponse(MessageOutput.BuilderImpl response) {
            this.response = response != null ? response.build() : null;
        }

        @Override
        public final Builder response(MessageOutput response) {
            this.response = response;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetNextMessageResponse build() {
            return new GetNextMessageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNextMessageResponse> {
        public Builder conversationSessionData(Collection<RuntimeSessionData> var1);

        public Builder conversationSessionData(RuntimeSessionData ... var1);

        public Builder conversationSessionData(Consumer<RuntimeSessionData.Builder> ... var1);

        public Builder conversationState(ConversationState var1);

        default public Builder conversationState(Consumer<ConversationState.Builder> conversationState) {
            return this.conversationState((ConversationState)((ConversationState.Builder)ConversationState.builder().applyMutation(conversationState)).build());
        }

        public Builder nextMessageToken(String var1);

        public Builder requestMessageId(String var1);

        public Builder response(MessageOutput var1);

        default public Builder response(Consumer<MessageOutput.Builder> response) {
            return this.response((MessageOutput)((MessageOutput.Builder)MessageOutput.builder().applyMutation(response)).build());
        }

        public Builder type(String var1);

        public Builder type(MessageType var1);
    }
}

