/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChannelSubtype {
    EMAIL("EMAIL"),
    SMS("SMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChannelSubtype> VALUE_MAP;
    private final String value;

    private ChannelSubtype(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChannelSubtype fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChannelSubtype> knownValues() {
        EnumSet<ChannelSubtype> knownValues = EnumSet.allOf(ChannelSubtype.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChannelSubtype.class, ChannelSubtype::toString);
    }
}

