/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model.chatoutputstream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.qbusiness.model.AuthChallengeRequestEvent;
import software.amazon.awssdk.services.qbusiness.model.ChatOutputStream;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.qbusiness.model.AuthChallengeRequestEvent} that represents
 * the {@code ChatOutputStream$authChallengeRequestEvent} event. Do not use this class directly. Instead, use the static
 * builder methods on {@link software.amazon.awssdk.services.qbusiness.model.ChatOutputStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultAuthChallengeRequestEvent extends AuthChallengeRequestEvent {
    private static final long serialVersionUID = 1L;

    DefaultAuthChallengeRequestEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(ChatResponseHandler.Visitor visitor) {
        visitor.visitAuthChallengeRequestEvent(this);
    }

    @Override
    public ChatOutputStream.EventType sdkEventType() {
        return ChatOutputStream.EventType.AUTH_CHALLENGE_REQUEST_EVENT;
    }

    public interface Builder extends AuthChallengeRequestEvent.Builder {
        @Override
        DefaultAuthChallengeRequestEvent build();
    }

    private static final class BuilderImpl extends AuthChallengeRequestEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultAuthChallengeRequestEvent event) {
            super(event);
        }

        @Override
        public DefaultAuthChallengeRequestEvent build() {
            return new DefaultAuthChallengeRequestEvent(this);
        }
    }
}
