/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a video source, including its identifier, format, and time information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoSourceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoSourceDetails.Builder, VideoSourceDetails> {
    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaId").getter(getter(VideoSourceDetails::mediaId)).setter(setter(Builder::mediaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaId").build()).build();

    private static final SdkField<String> MEDIA_MIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaMimeType").getter(getter(VideoSourceDetails::mediaMimeType)).setter(setter(Builder::mediaMimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaMimeType").build()).build();

    private static final SdkField<Long> START_TIME_MILLISECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startTimeMilliseconds").getter(getter(VideoSourceDetails::startTimeMilliseconds))
            .setter(setter(Builder::startTimeMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeMilliseconds").build())
            .build();

    private static final SdkField<Long> END_TIME_MILLISECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("endTimeMilliseconds").getter(getter(VideoSourceDetails::endTimeMilliseconds))
            .setter(setter(Builder::endTimeMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeMilliseconds").build())
            .build();

    private static final SdkField<String> VIDEO_EXTRACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("videoExtractionType").getter(getter(VideoSourceDetails::videoExtractionTypeAsString))
            .setter(setter(Builder::videoExtractionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoExtractionType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_ID_FIELD,
            MEDIA_MIME_TYPE_FIELD, START_TIME_MILLISECONDS_FIELD, END_TIME_MILLISECONDS_FIELD, VIDEO_EXTRACTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mediaId;

    private final String mediaMimeType;

    private final Long startTimeMilliseconds;

    private final Long endTimeMilliseconds;

    private final String videoExtractionType;

    private VideoSourceDetails(BuilderImpl builder) {
        this.mediaId = builder.mediaId;
        this.mediaMimeType = builder.mediaMimeType;
        this.startTimeMilliseconds = builder.startTimeMilliseconds;
        this.endTimeMilliseconds = builder.endTimeMilliseconds;
        this.videoExtractionType = builder.videoExtractionType;
    }

    /**
     * <p>
     * Unique identifier for the video media file.
     * </p>
     * 
     * @return Unique identifier for the video media file.
     */
    public final String mediaId() {
        return mediaId;
    }

    /**
     * <p>
     * The MIME type of the video file (e.g., video/mp4, video/avi).
     * </p>
     * 
     * @return The MIME type of the video file (e.g., video/mp4, video/avi).
     */
    public final String mediaMimeType() {
        return mediaMimeType;
    }

    /**
     * <p>
     * The starting timestamp in milliseconds for the relevant video segment.
     * </p>
     * 
     * @return The starting timestamp in milliseconds for the relevant video segment.
     */
    public final Long startTimeMilliseconds() {
        return startTimeMilliseconds;
    }

    /**
     * <p>
     * The ending timestamp in milliseconds for the relevant video segment.
     * </p>
     * 
     * @return The ending timestamp in milliseconds for the relevant video segment.
     */
    public final Long endTimeMilliseconds() {
        return endTimeMilliseconds;
    }

    /**
     * <p>
     * The type of video extraction performed on the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #videoExtractionType} will return {@link VideoExtractionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #videoExtractionTypeAsString}.
     * </p>
     * 
     * @return The type of video extraction performed on the content.
     * @see VideoExtractionType
     */
    public final VideoExtractionType videoExtractionType() {
        return VideoExtractionType.fromValue(videoExtractionType);
    }

    /**
     * <p>
     * The type of video extraction performed on the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #videoExtractionType} will return {@link VideoExtractionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #videoExtractionTypeAsString}.
     * </p>
     * 
     * @return The type of video extraction performed on the content.
     * @see VideoExtractionType
     */
    public final String videoExtractionTypeAsString() {
        return videoExtractionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaMimeType());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(videoExtractionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSourceDetails)) {
            return false;
        }
        VideoSourceDetails other = (VideoSourceDetails) obj;
        return Objects.equals(mediaId(), other.mediaId()) && Objects.equals(mediaMimeType(), other.mediaMimeType())
                && Objects.equals(startTimeMilliseconds(), other.startTimeMilliseconds())
                && Objects.equals(endTimeMilliseconds(), other.endTimeMilliseconds())
                && Objects.equals(videoExtractionTypeAsString(), other.videoExtractionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoSourceDetails").add("MediaId", mediaId()).add("MediaMimeType", mediaMimeType())
                .add("StartTimeMilliseconds", startTimeMilliseconds()).add("EndTimeMilliseconds", endTimeMilliseconds())
                .add("VideoExtractionType", videoExtractionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mediaId":
            return Optional.ofNullable(clazz.cast(mediaId()));
        case "mediaMimeType":
            return Optional.ofNullable(clazz.cast(mediaMimeType()));
        case "startTimeMilliseconds":
            return Optional.ofNullable(clazz.cast(startTimeMilliseconds()));
        case "endTimeMilliseconds":
            return Optional.ofNullable(clazz.cast(endTimeMilliseconds()));
        case "videoExtractionType":
            return Optional.ofNullable(clazz.cast(videoExtractionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mediaId", MEDIA_ID_FIELD);
        map.put("mediaMimeType", MEDIA_MIME_TYPE_FIELD);
        map.put("startTimeMilliseconds", START_TIME_MILLISECONDS_FIELD);
        map.put("endTimeMilliseconds", END_TIME_MILLISECONDS_FIELD);
        map.put("videoExtractionType", VIDEO_EXTRACTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoSourceDetails, T> g) {
        return obj -> g.apply((VideoSourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoSourceDetails> {
        /**
         * <p>
         * Unique identifier for the video media file.
         * </p>
         * 
         * @param mediaId
         *        Unique identifier for the video media file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaId(String mediaId);

        /**
         * <p>
         * The MIME type of the video file (e.g., video/mp4, video/avi).
         * </p>
         * 
         * @param mediaMimeType
         *        The MIME type of the video file (e.g., video/mp4, video/avi).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaMimeType(String mediaMimeType);

        /**
         * <p>
         * The starting timestamp in milliseconds for the relevant video segment.
         * </p>
         * 
         * @param startTimeMilliseconds
         *        The starting timestamp in milliseconds for the relevant video segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeMilliseconds(Long startTimeMilliseconds);

        /**
         * <p>
         * The ending timestamp in milliseconds for the relevant video segment.
         * </p>
         * 
         * @param endTimeMilliseconds
         *        The ending timestamp in milliseconds for the relevant video segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeMilliseconds(Long endTimeMilliseconds);

        /**
         * <p>
         * The type of video extraction performed on the content.
         * </p>
         * 
         * @param videoExtractionType
         *        The type of video extraction performed on the content.
         * @see VideoExtractionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoExtractionType
         */
        Builder videoExtractionType(String videoExtractionType);

        /**
         * <p>
         * The type of video extraction performed on the content.
         * </p>
         * 
         * @param videoExtractionType
         *        The type of video extraction performed on the content.
         * @see VideoExtractionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoExtractionType
         */
        Builder videoExtractionType(VideoExtractionType videoExtractionType);
    }

    static final class BuilderImpl implements Builder {
        private String mediaId;

        private String mediaMimeType;

        private Long startTimeMilliseconds;

        private Long endTimeMilliseconds;

        private String videoExtractionType;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSourceDetails model) {
            mediaId(model.mediaId);
            mediaMimeType(model.mediaMimeType);
            startTimeMilliseconds(model.startTimeMilliseconds);
            endTimeMilliseconds(model.endTimeMilliseconds);
            videoExtractionType(model.videoExtractionType);
        }

        public final String getMediaId() {
            return mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public final String getMediaMimeType() {
            return mediaMimeType;
        }

        public final void setMediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
        }

        @Override
        public final Builder mediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
            return this;
        }

        public final Long getStartTimeMilliseconds() {
            return startTimeMilliseconds;
        }

        public final void setStartTimeMilliseconds(Long startTimeMilliseconds) {
            this.startTimeMilliseconds = startTimeMilliseconds;
        }

        @Override
        public final Builder startTimeMilliseconds(Long startTimeMilliseconds) {
            this.startTimeMilliseconds = startTimeMilliseconds;
            return this;
        }

        public final Long getEndTimeMilliseconds() {
            return endTimeMilliseconds;
        }

        public final void setEndTimeMilliseconds(Long endTimeMilliseconds) {
            this.endTimeMilliseconds = endTimeMilliseconds;
        }

        @Override
        public final Builder endTimeMilliseconds(Long endTimeMilliseconds) {
            this.endTimeMilliseconds = endTimeMilliseconds;
            return this;
        }

        public final String getVideoExtractionType() {
            return videoExtractionType;
        }

        public final void setVideoExtractionType(String videoExtractionType) {
            this.videoExtractionType = videoExtractionType;
        }

        @Override
        public final Builder videoExtractionType(String videoExtractionType) {
            this.videoExtractionType = videoExtractionType;
            return this;
        }

        @Override
        public final Builder videoExtractionType(VideoExtractionType videoExtractionType) {
            this.videoExtractionType(videoExtractionType == null ? null : videoExtractionType.toString());
            return this;
        }

        @Override
        public VideoSourceDetails build() {
            return new VideoSourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
