/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for video content extraction and processing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoExtractionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoExtractionConfiguration.Builder, VideoExtractionConfiguration> {
    private static final SdkField<String> VIDEO_EXTRACTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("videoExtractionStatus").getter(getter(VideoExtractionConfiguration::videoExtractionStatusAsString))
            .setter(setter(Builder::videoExtractionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoExtractionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VIDEO_EXTRACTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String videoExtractionStatus;

    private VideoExtractionConfiguration(BuilderImpl builder) {
        this.videoExtractionStatus = builder.videoExtractionStatus;
    }

    /**
     * <p>
     * The status of video extraction (ENABLED or DISABLED) for processing video content from files.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #videoExtractionStatus} will return {@link VideoExtractionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #videoExtractionStatusAsString}.
     * </p>
     * 
     * @return The status of video extraction (ENABLED or DISABLED) for processing video content from files.
     * @see VideoExtractionStatus
     */
    public final VideoExtractionStatus videoExtractionStatus() {
        return VideoExtractionStatus.fromValue(videoExtractionStatus);
    }

    /**
     * <p>
     * The status of video extraction (ENABLED or DISABLED) for processing video content from files.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #videoExtractionStatus} will return {@link VideoExtractionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #videoExtractionStatusAsString}.
     * </p>
     * 
     * @return The status of video extraction (ENABLED or DISABLED) for processing video content from files.
     * @see VideoExtractionStatus
     */
    public final String videoExtractionStatusAsString() {
        return videoExtractionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(videoExtractionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoExtractionConfiguration)) {
            return false;
        }
        VideoExtractionConfiguration other = (VideoExtractionConfiguration) obj;
        return Objects.equals(videoExtractionStatusAsString(), other.videoExtractionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoExtractionConfiguration").add("VideoExtractionStatus", videoExtractionStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "videoExtractionStatus":
            return Optional.ofNullable(clazz.cast(videoExtractionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("videoExtractionStatus", VIDEO_EXTRACTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoExtractionConfiguration, T> g) {
        return obj -> g.apply((VideoExtractionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoExtractionConfiguration> {
        /**
         * <p>
         * The status of video extraction (ENABLED or DISABLED) for processing video content from files.
         * </p>
         * 
         * @param videoExtractionStatus
         *        The status of video extraction (ENABLED or DISABLED) for processing video content from files.
         * @see VideoExtractionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoExtractionStatus
         */
        Builder videoExtractionStatus(String videoExtractionStatus);

        /**
         * <p>
         * The status of video extraction (ENABLED or DISABLED) for processing video content from files.
         * </p>
         * 
         * @param videoExtractionStatus
         *        The status of video extraction (ENABLED or DISABLED) for processing video content from files.
         * @see VideoExtractionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoExtractionStatus
         */
        Builder videoExtractionStatus(VideoExtractionStatus videoExtractionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String videoExtractionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoExtractionConfiguration model) {
            videoExtractionStatus(model.videoExtractionStatus);
        }

        public final String getVideoExtractionStatus() {
            return videoExtractionStatus;
        }

        public final void setVideoExtractionStatus(String videoExtractionStatus) {
            this.videoExtractionStatus = videoExtractionStatus;
        }

        @Override
        public final Builder videoExtractionStatus(String videoExtractionStatus) {
            this.videoExtractionStatus = videoExtractionStatus;
            return this;
        }

        @Override
        public final Builder videoExtractionStatus(VideoExtractionStatus videoExtractionStatus) {
            this.videoExtractionStatus(videoExtractionStatus == null ? null : videoExtractionStatus.toString());
            return this;
        }

        @Override
        public VideoExtractionConfiguration build() {
            return new VideoExtractionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
